/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.theme.render;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jboss.portal.common.net.media.MediaType;
import org.jboss.portal.common.util.MarkupInfo;
import org.jboss.portal.theme.render.ObjectRenderer;
import org.jboss.portal.theme.render.ObjectRendererContext;
import org.jboss.portal.theme.render.PropertyFetch;
import org.jboss.portal.theme.render.RenderException;
import org.jboss.portal.theme.render.RendererFactory;
import org.jboss.portal.theme.render.ThemeContext;
import org.jboss.portal.theme.render.renderer.DecorationRenderer;
import org.jboss.portal.theme.render.renderer.DecorationRendererContext;
import org.jboss.portal.theme.render.renderer.PageRenderer;
import org.jboss.portal.theme.render.renderer.PageRendererContext;
import org.jboss.portal.theme.render.renderer.PortletRenderer;
import org.jboss.portal.theme.render.renderer.PortletRendererContext;
import org.jboss.portal.theme.render.renderer.RegionRenderer;
import org.jboss.portal.theme.render.renderer.RegionRendererContext;
import org.jboss.portal.theme.render.renderer.WindowRenderer;
import org.jboss.portal.theme.render.renderer.WindowRendererContext;
import org.jboss.portal.web.ServletContextDispatcher;

public abstract class RendererContext {
    private final ThemeContext themeContext;
    private final RendererFactory rendererFactory;
    private final ServletContextDispatcher dispatcher;
    private final MarkupInfo markupInfo;
    private final ArrayList stack;
    private final Map attributes;

    public RendererContext(ThemeContext themeContext, RendererFactory rendererFactory, ServletContextDispatcher dispatcher, MarkupInfo markupInfo) {
        if (themeContext == null) {
            throw new IllegalArgumentException("no theme factory provided");
        }
        if (rendererFactory == null) {
            throw new IllegalArgumentException("no renderer factory provided");
        }
        if (dispatcher == null) {
            throw new IllegalArgumentException("no server invocation provided");
        }
        if (markupInfo == null) {
            throw new IllegalArgumentException("no stream info provided");
        }
        this.themeContext = themeContext;
        this.rendererFactory = rendererFactory;
        this.dispatcher = dispatcher;
        this.markupInfo = markupInfo;
        this.stack = new ArrayList(6);
        this.attributes = new HashMap();
    }

    public abstract PrintWriter getWriter();

    public ThemeContext getThemeContext() {
        return this.themeContext;
    }

    public ServletContextDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public MarkupInfo getMarkupInfo() {
        return this.markupInfo;
    }

    public MediaType getMediaType() {
        return this.markupInfo.getMediaType();
    }

    public String getCharset() {
        return this.markupInfo.getCharset();
    }

    public Object getAttribute(String attrName) {
        if (attrName == null) {
            throw new IllegalArgumentException("No null attribute name");
        }
        return this.attributes.get(attrName);
    }

    public void setAttribute(String attrName, Object attrValue) {
        if (attrName == null) {
            throw new IllegalArgumentException("No null attribute name");
        }
        if (attrValue != null) {
            this.attributes.put(attrName, attrValue);
        } else {
            this.attributes.remove(attrName);
        }
    }

    public String getProperty(String propertyName) {
        return this.getProperty(propertyName, this.stack.size() - 1);
    }

    public String getProperty(String propertyName, PropertyFetch fetch) {
        return this.getProperty(propertyName, this.stack.size() - (fetch.getScope() == 0 ? 1 : 2));
    }

    private String getProperty(String propertyName, int from) {
        for (int i = from; i >= 0; --i) {
            ObjectRendererContext ctx = (ObjectRendererContext)this.stack.get(i);
            String propertyValue = ctx.getProperty(propertyName);
            if (propertyValue == null) continue;
            return propertyValue;
        }
        return null;
    }

    public void pushObjectRenderContext(ObjectRendererContext objectRendererContext) {
        this.stack.add(objectRendererContext);
        ObjectRenderer renderer = this.rendererFactory.getRenderer(this, objectRendererContext);
        renderer.startContext(this, objectRendererContext);
    }

    public ObjectRendererContext popObjectRenderContext() {
        ObjectRendererContext objectRendererContext = (ObjectRendererContext)this.stack.remove(this.stack.size() - 1);
        ObjectRenderer renderer = this.rendererFactory.getRenderer(this, objectRendererContext);
        renderer.endContext(this, objectRendererContext);
        return objectRendererContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(ObjectRendererContext ctx) throws RenderException, IllegalStateException {
        this.pushObjectRenderContext(ctx);
        try {
            ObjectRenderer renderer;
            ObjectRendererContext prc;
            if (ctx instanceof PageRendererContext) {
                prc = (PageRendererContext)ctx;
                renderer = (PageRenderer)this.rendererFactory.getRenderer(this, prc);
                renderer.render(this, (PageRendererContext)prc);
            }
            if (ctx instanceof WindowRendererContext) {
                WindowRendererContext wrc = (WindowRendererContext)ctx;
                renderer = (WindowRenderer)this.rendererFactory.getRenderer(this, wrc);
                renderer.render(this, wrc);
            } else if (ctx instanceof RegionRendererContext) {
                RegionRendererContext rrc = (RegionRendererContext)ctx;
                renderer = (RegionRenderer)this.rendererFactory.getRenderer(this, rrc);
                renderer.renderHeader(this, rrc);
                renderer.renderBody(this, rrc);
                renderer.renderFooter(this, rrc);
            } else if (ctx instanceof PortletRendererContext) {
                prc = (PortletRendererContext)ctx;
                renderer = (PortletRenderer)this.rendererFactory.getRenderer(this, prc);
                renderer.render(this, (PortletRendererContext)prc);
            } else if (ctx instanceof DecorationRendererContext) {
                DecorationRendererContext drc = (DecorationRendererContext)ctx;
                renderer = (DecorationRenderer)this.rendererFactory.getRenderer(this, drc);
                renderer.render(this, drc);
            }
        }
        finally {
            this.popObjectRenderContext();
        }
    }
}

