/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.metadata.profile.info;

import java.util.HashMap;
import java.util.Locale;
import org.jboss.logging.Logger;
import org.jboss.portal.common.i18n.LocalizedString;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.info.PropertyInfo;
import org.jboss.portal.identity.metadata.profile.LocalizedValueMetaData;
import org.jboss.portal.identity.metadata.profile.PropertyMetaData;

public class PropertyInfoSupport
implements PropertyInfo {
    private static final Logger log = Logger.getLogger(PropertyInfo.class);
    private String name;
    private String type;
    private String accessMode;
    private String usage;
    private LocalizedString displayName;
    private LocalizedString description;
    private String mappingDBType;
    private String mappingDBValue;
    private String mappingLDAPValue;
    private boolean mappedLDAP;
    private boolean mappedDB;

    public PropertyInfoSupport(PropertyMetaData meta) throws IdentityException {
        this.name = meta.getName();
        this.type = meta.getType();
        this.accessMode = meta.getAccessMode();
        if (!this.accessMode.equals("read-only") && !this.accessMode.equals("read-write")) {
            throw new IdentityException("Wrong value in user profile configuration for access-mode: " + this.accessMode);
        }
        this.usage = meta.getUsage();
        if (!this.usage.equals("mandatory") && !this.usage.equals("optional")) {
            throw new IdentityException("Wrong value in user profile configuration for usage: " + this.usage);
        }
        HashMap<Locale, String> descValues = new HashMap<Locale, String>();
        for (LocalizedValueMetaData value : meta.getDescription().getValues()) {
            descValues.put(value.getLocale(), value.getValue());
        }
        HashMap<Locale, String> dispValues = new HashMap<Locale, String>();
        for (LocalizedValueMetaData value : meta.getDisplayName().getValues()) {
            dispValues.put(value.getLocale(), value.getValue());
        }
        this.description = new LocalizedString(descValues, Locale.ENGLISH);
        this.displayName = new LocalizedString(dispValues, Locale.ENGLISH);
        if (meta.getMapping() == null) {
            throw new IdentityException("Mapping section is missing");
        }
        if (meta.getMapping().getMappingDatabase() != null && meta.getMapping().getMappingDatabase().getType() != null && meta.getMapping().getMappingDatabase().getValue() != null) {
            this.mappedDB = true;
            this.mappingDBType = meta.getMapping().getMappingDatabase().getType();
            if (!this.mappingDBType.equals("column") && !this.mappingDBType.equals("dynamic")) {
                throw new IdentityException("Wrong value in user profile configuration for database mapping type: " + this.mappingDBType);
            }
            this.mappingDBValue = meta.getMapping().getMappingDatabase().getValue();
        }
        if (meta.getMapping().getMappingLDAP() != null && meta.getMapping().getMappingLDAP().getValue() != null) {
            this.mappedLDAP = true;
            this.mappingLDAPValue = meta.getMapping().getMappingLDAP().getValue();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("created PropertyInfo: " + this.toString()));
        }
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getAccessMode() {
        return this.accessMode;
    }

    public String getUsage() {
        return this.usage;
    }

    public LocalizedString getDisplayName() {
        return this.displayName;
    }

    public LocalizedString getDescription() {
        return this.description;
    }

    public String getMappingDBType() {
        return this.mappingDBType;
    }

    public String getMappingLDAPValue() {
        return this.mappingLDAPValue;
    }

    public String getMappingDBValue() {
        return this.mappingDBValue;
    }

    public boolean isMappedDB() {
        return this.mappedDB;
    }

    public boolean isMappedLDAP() {
        return this.mappedLDAP;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("name: ").append(this.name).append("; type:").append(this.type).append("; accessMode:").append(this.accessMode).append("; usage: ").append(this.usage).append("; displayName: ").append(this.displayName).append("; description: ").append(this.description).append("; mappingDBType: ").append(this.mappingDBType).append("; mappingLDAPValue: ").append(this.mappingLDAPValue).append("; mappingDBValue: ").append(this.mappingDBValue).append("; mappedDB: ").append(this.mappedDB).append("; mappedLDAP: ").append(this.mappedLDAP);
        return buf.toString();
    }
}

