/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.service;

import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.portal.identity.IdentityConfiguration;
import org.jboss.portal.identity.IdentityContext;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.ServiceJNDIBinder;
import org.jboss.portal.identity.event.IdentityEventBroadcaster;

public class IdentityModuleService {
    private static final Logger log = Logger.getLogger(IdentityModuleService.class);
    private String jndiName;
    private String connectionJNDIName;
    private IdentityContext identityContext;
    private IdentityConfiguration identityConfiguration;
    private ServiceJNDIBinder jndiBinder;
    private Map initOptions;
    protected String moduleType;

    private IdentityModuleService() {
    }

    protected IdentityModuleService(String type) {
        this.moduleType = type;
    }

    public void start() throws Exception {
        if (this.jndiName != null && this.jndiBinder != null) {
            log.debug((Object)("Binding identity module to JNDI with name: " + this.jndiName));
            this.jndiBinder.bind(this.jndiName, this);
        }
        if (this.identityContext == null) {
            throw new IdentityException("Cannot register module in context - missing reference");
        }
        this.identityContext.register(this, this.moduleType);
    }

    public void stop() throws Exception {
        if (this.jndiName != null && this.jndiBinder != null) {
            this.jndiBinder.unbind(this.jndiName);
        }
        if (this.identityContext == null) {
            log.error((Object)"Cannot unregister module in context - missing reference");
        } else {
            this.identityContext.unregister(this.moduleType);
        }
    }

    protected IdentityConfiguration getIdentityConfiguration() {
        try {
            if (this.identityConfiguration == null) {
                this.identityConfiguration = (IdentityConfiguration)this.identityContext.getObject("IdentityConfiguration");
            }
            return this.identityConfiguration;
        }
        catch (IdentityException e) {
            throw new RuntimeException("Can't obtain IdentityConfiguration", e);
        }
    }

    protected IdentityEventBroadcaster getIdentityEventBroadcaster() throws IdentityException {
        return (IdentityEventBroadcaster)this.getIdentityContext().getObject("IdentityEventBroadcaster");
    }

    public IdentityContext getIdentityContext() {
        return this.identityContext;
    }

    public void setIdentityContext(IdentityContext identityContext) {
        this.identityContext = identityContext;
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public void setJNDIName(String JNDIName) {
        this.jndiName = JNDIName;
    }

    public Map getInitOptions() {
        return this.initOptions;
    }

    public void setInitOptions(Map initOptions) {
        this.initOptions = initOptions;
    }

    public String getModuleType() {
        return this.moduleType;
    }

    public void setModuleType(String moduleType) {
        this.moduleType = moduleType;
    }

    public String getConnectionJNDIName() {
        return this.connectionJNDIName;
    }

    public void setConnectionJNDIName(String connectionJNDIName) {
        this.connectionJNDIName = connectionJNDIName;
    }

    public ServiceJNDIBinder getJndiBinder() {
        return this.jndiBinder;
    }

    public void setJndiBinder(ServiceJNDIBinder jndiBinder) {
        this.jndiBinder = jndiBinder;
    }
}

