/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.admin.ui;

import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import org.jboss.portal.core.model.portal.PortalObject;

public class ThemeBean {
    private final PortalObject portalObject;
    private String layoutName;
    private String themeName;
    private String renderSetName;
    private String windowRendererName;
    private String decorationRendererName;
    private String portletRendererName;

    public ThemeBean(PortalObject portalObject) {
        this.portalObject = portalObject;
        this.layoutName = portalObject.getDeclaredProperty("layout.id");
        this.themeName = portalObject.getDeclaredProperty("theme.id");
        this.renderSetName = portalObject.getDeclaredProperty("theme.renderSetId");
        this.windowRendererName = portalObject.getDeclaredProperty("theme.windowRendererId");
        this.decorationRendererName = portalObject.getDeclaredProperty("theme.decorationRendererId");
        this.portletRendererName = portalObject.getDeclaredProperty("theme.portletRendererId");
    }

    public PortalObject getPortalObject() {
        return this.portalObject;
    }

    public String getLayoutName() {
        return this.layoutName != null ? this.layoutName : "";
    }

    public void setLayoutName(String layoutName) {
        this.layoutName = "".equals(layoutName) ? null : layoutName;
    }

    public String getThemeName() {
        return this.themeName != null ? this.themeName : "";
    }

    public void setThemeName(String themeName) {
        this.themeName = "".equals(themeName) ? null : themeName;
    }

    public String getRenderSetName() {
        return this.renderSetName != null ? this.renderSetName : "";
    }

    public void setRenderSetName(String renderSetName) {
        this.renderSetName = "".equals(renderSetName) ? null : renderSetName;
    }

    public String getWindowRendererName() {
        return this.windowRendererName != null ? this.windowRendererName : "";
    }

    public void setWindowRendererName(String windowRendererName) {
        this.windowRendererName = "".equals(windowRendererName) ? null : windowRendererName;
    }

    public String getDecorationRendererName() {
        return this.decorationRendererName != null ? this.decorationRendererName : "";
    }

    public void setDecorationRendererName(String decorationRendererName) {
        this.decorationRendererName = "".equals(decorationRendererName) ? null : decorationRendererName;
    }

    public String getPortletRendererName() {
        return this.portletRendererName != null ? this.portletRendererName : "";
    }

    public void setPortletRendererName(String portletRendererName) {
        this.portletRendererName = "".equals(portletRendererName) ? null : portletRendererName;
    }

    public void execute(ActionEvent actionEvent) throws AbortProcessingException {
        boolean successful = true;
        switch (this.portalObject.getType()) {
            case 0: 
            case 1: 
            case 2: {
                this.portalObject.setDeclaredProperty("layout.id", this.layoutName);
                this.portalObject.setDeclaredProperty("theme.id", this.themeName);
                this.portalObject.setDeclaredProperty("theme.renderSetId", this.renderSetName);
                break;
            }
            case 3: {
                this.portalObject.setDeclaredProperty("theme.windowRendererId", this.windowRendererName);
                this.portalObject.setDeclaredProperty("theme.decorationRendererId", this.decorationRendererName);
                this.portalObject.setDeclaredProperty("theme.portletRendererId", this.portletRendererName);
                break;
            }
            default: {
                successful = false;
            }
        }
        if (successful) {
            String stringMessage = null;
            switch (this.portalObject.getType()) {
                case 1: {
                    stringMessage = "Theme has been correctly updated on the portal named: " + this.portalObject.getName();
                    break;
                }
                case 2: {
                    stringMessage = "Theme has been correctly updated on the page named: " + this.portalObject.getName();
                    break;
                }
                case 3: {
                    stringMessage = "Theme has been correctly updated on the window named: " + this.portalObject.getName();
                }
            }
            if (stringMessage != null) {
                FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_INFO, stringMessage, stringMessage);
                FacesContext.getCurrentInstance().addMessage("status", message);
            }
        } else {
            String stringMessage = "Unknown object type, please file a Jira issue: http://jira.jboss.org";
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, stringMessage, stringMessage);
            FacesContext.getCurrentInstance().addMessage("error", message);
        }
    }
}

