/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.def;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jbpm.JbpmException;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.SuperState;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.log.TransitionLog;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;

public class Transition
extends GraphElement {
    private static final long serialVersionUID = 1L;
    protected Node from = null;
    protected Node to = null;
    protected String condition = null;
    transient boolean isConditionEnforced = true;
    public static final String[] supportedEventTypes = new String[]{"transition"};

    public String[] getSupportedEventTypes() {
        return supportedEventTypes;
    }

    public Transition() {
    }

    public Transition(String name) {
        super(name);
    }

    public Node getFrom() {
        return this.from;
    }

    public void setFrom(Node from) {
        this.from = from;
    }

    public void setTo(Node to) {
        this.to = to;
    }

    public Node getTo() {
        return this.to;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String conditionExpression) {
        this.condition = conditionExpression;
    }

    public void removeConditionEnforcement() {
        this.isConditionEnforced = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void take(ExecutionContext executionContext) {
        executionContext.getToken().setNode(null);
        Token token = executionContext.getToken();
        if (this.condition != null && this.isConditionEnforced) {
            Object result = JbpmExpressionEvaluator.evaluate(this.condition, executionContext);
            if (result == null) {
                throw new JbpmException("transition condition " + this.condition + " evaluated to null");
            }
            if (!(result instanceof Boolean)) {
                throw new JbpmException("transition condition " + this.condition + " evaluated to non-boolean: " + result.getClass().getName());
            }
            if (!((Boolean)result).booleanValue()) {
                throw new JbpmException("transition condition " + this.condition + " evaluated to 'false'");
            }
        }
        TransitionLog transitionLog = new TransitionLog(this, executionContext.getTransitionSource());
        token.startCompositeLog(transitionLog);
        try {
            this.fireSuperStateLeaveEvents(executionContext);
            this.fireEvent("transition", executionContext);
            Node destination = this.fireSuperStateEnterEvents(executionContext);
            transitionLog.setDestinationNode(destination);
        }
        finally {
            token.endCompositeLog();
        }
        this.to.enter(executionContext);
    }

    Node fireSuperStateEnterEvents(ExecutionContext executionContext) {
        Node destination = this.to;
        while (destination.isSuperStateNode()) {
            destination = (Node)destination.getNodes().get(0);
        }
        if (destination == null) {
            String transitionName = this.name != null ? "'" + this.name + "'" : "in node '" + this.from + "'";
            throw new JbpmException("transition " + transitionName + " doesn't have destination. check your processdefinition.xml");
        }
        if (destination.getSuperState() != null) {
            List leavingSuperStates = Transition.collectAllSuperStates(destination, this.from);
            Collections.reverse(leavingSuperStates);
            this.fireSuperStateEvents(leavingSuperStates, "superstate-enter", executionContext);
        }
        return destination;
    }

    void fireSuperStateLeaveEvents(ExecutionContext executionContext) {
        if (executionContext.getTransitionSource().getSuperState() != null) {
            List leavingSuperStates = Transition.collectAllSuperStates(executionContext.getTransitionSource(), this.to);
            this.fireSuperStateEvents(leavingSuperStates, "superstate-leave", executionContext);
        }
    }

    static List collectAllSuperStates(Node a, Node b) {
        SuperState superState = a.getSuperState();
        ArrayList<SuperState> leavingSuperStates = new ArrayList<SuperState>();
        while (superState != null) {
            if (!superState.containsNode(b)) {
                leavingSuperStates.add(superState);
                superState = superState.getSuperState();
                continue;
            }
            superState = null;
        }
        return leavingSuperStates;
    }

    void fireSuperStateEvents(List superStates, String eventType, ExecutionContext executionContext) {
        Iterator iter = superStates.iterator();
        while (iter.hasNext()) {
            SuperState leavingSuperState = (SuperState)iter.next();
            leavingSuperState.fireEvent(eventType, executionContext);
        }
    }

    public void setName(String name) {
        if (this.from != null) {
            if (this.from.hasLeavingTransition(name)) {
                throw new IllegalArgumentException("couldn't set name '" + name + "' on transition '" + this + "'cause the from-node of this transition has already another leaving transition with the same name");
            }
            Map fromLeavingTransitions = this.from.getLeavingTransitionsMap();
            fromLeavingTransitions.remove(this.name);
            fromLeavingTransitions.put(name, this);
        }
        this.name = name;
    }

    public GraphElement getParent() {
        GraphElement parent = null;
        if (this.from != null && this.to != null) {
            if (this.from.equals(this.to)) {
                parent = this.from.getParent();
            } else {
                List fromParentChain = this.from.getParentChain();
                List toParentChain = this.to.getParentChain();
                Iterator fromIter = fromParentChain.iterator();
                while (fromIter.hasNext() && parent == null) {
                    GraphElement fromParent = (GraphElement)fromIter.next();
                    Iterator toIter = toParentChain.iterator();
                    while (toIter.hasNext() && parent == null) {
                        GraphElement toParent = (GraphElement)toIter.next();
                        if (fromParent != toParent) continue;
                        parent = fromParent;
                    }
                }
            }
        }
        return parent;
    }
}

