/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Closeable;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.GetStateEvent;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.SetStateEvent;
import org.jgroups.StreamingGetStateEvent;
import org.jgroups.StreamingSetStateEvent;
import org.jgroups.View;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

public class StateTransferTest
extends TestCase {
    final int NUM = 10000;
    final int NUM_THREADS = 2;
    String props = "udp.xml";

    public StateTransferTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.props = System.getProperty("props", this.props);
        StateTransferTest.log("Using configuration file " + this.props);
        super.setUp();
    }

    public void testStateTransferWhileSending() throws Exception {
        Worker worker;
        int i;
        Worker[] workers = new Worker[2];
        int from = 0;
        int to = 10000;
        for (i = 0; i < workers.length; ++i) {
            workers[i] = new Worker(from, to);
            from += 10000;
            to += 10000;
        }
        for (i = 0; i < workers.length; ++i) {
            worker = workers[i];
            worker.start();
            Util.sleep(50L);
        }
        for (i = 0; i < workers.length; ++i) {
            worker = workers[i];
            worker.waitUntilDone();
        }
        for (i = 0; i < workers.length; ++i) {
            worker = workers[i];
            worker.stop();
        }
        StateTransferTest.log("\n\nhashmaps\n");
        for (i = 0; i < workers.length; ++i) {
            Worker w = workers[i];
            Map m = w.getMap();
            StateTransferTest.log("map has " + m.size() + " elements");
            StateTransferTest.assertEquals((int)20000, (int)m.size());
        }
        Set keys = workers[0].getMap().keySet();
        for (int i2 = 0; i2 < workers.length; ++i2) {
            Worker w = workers[i2];
            Map m = w.getMap();
            Set s = m.keySet();
            StateTransferTest.assertEquals(keys, s);
        }
    }

    static void log(String msg) {
        System.out.println(Thread.currentThread() + " -- " + msg);
    }

    public static Test suite() {
        return new TestSuite(StateTransferTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)StateTransferTest.suite());
    }

    class Receiver
    extends Thread {
        JChannel ch;
        Promise promise;
        Map map;

        public Receiver(JChannel ch, Promise promise) {
            this.ch = ch;
            this.promise = promise;
            this.map = Collections.synchronizedMap(new HashMap(20000));
        }

        public Map getMap() {
            return this.map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int num_received = 0;
            int to_be_received = 20000;
            StateTransferTest.log("Receiver thread started");
            while (this.ch.isConnected()) {
                try {
                    Closeable stream;
                    Object evt;
                    byte[] state;
                    Object obj = this.ch.receive(0L);
                    if (obj instanceof Message) {
                        Object[] data = (Object[])((Message)obj).getObject();
                        Object prev_val = this.map.put(data[0], data[1]);
                        if (prev_val != null) continue;
                        num_received = this.map.size();
                        if (num_received % 1000 == 0) {
                            StateTransferTest.log("received " + num_received);
                        }
                        if (num_received < to_be_received) continue;
                        StateTransferTest.log("DONE: received " + num_received + " messages");
                        break;
                    }
                    if (obj instanceof View) {
                        StateTransferTest.log("VIEW: " + obj);
                        continue;
                    }
                    if (obj instanceof GetStateEvent) {
                        state = Util.objectToByteBuffer(this.map);
                        StateTransferTest.log("returning state, map has " + this.map.size() + " elements");
                        this.ch.returnState(state);
                        continue;
                    }
                    if (obj instanceof SetStateEvent) {
                        state = ((SetStateEvent)obj).getArg();
                        if (state == null) {
                            StateTransferTest.log("received null state");
                        } else {
                            Map tmp = (Map)Util.objectFromByteBuffer(state);
                            StateTransferTest.log("received state, map has " + tmp.size() + " elements");
                            this.map = Collections.synchronizedMap(tmp);
                        }
                        this.promise.setResult(Boolean.TRUE);
                        continue;
                    }
                    if (obj instanceof StreamingGetStateEvent) {
                        evt = (StreamingGetStateEvent)obj;
                        stream = ((StreamingGetStateEvent)evt).getArg();
                        ObjectOutputStream out = new ObjectOutputStream((OutputStream)stream);
                        Map map = this.map;
                        synchronized (map) {
                            out.writeObject(this.map);
                        }
                        out.close();
                        continue;
                    }
                    if (!(obj instanceof StreamingSetStateEvent)) continue;
                    evt = (StreamingSetStateEvent)obj;
                    stream = ((StreamingSetStateEvent)evt).getArg();
                    ObjectInputStream in = new ObjectInputStream((InputStream)stream);
                    this.map = Collections.synchronizedMap((Map)in.readObject());
                    in.close();
                    this.promise.setResult(Boolean.TRUE);
                }
                catch (Exception e) {
                    StateTransferTest.log("receiver thread terminated due to exception: " + e);
                    break;
                }
            }
            StateTransferTest.log("Receiver thread terminated");
        }
    }

    class Worker
    implements Runnable {
        JChannel ch;
        int to;
        int from;
        final Promise promise = new Promise();
        Thread t;
        Receiver receiver;

        public Worker(int from, int to) {
            this.to = to;
            this.from = from;
        }

        public Map getMap() {
            return this.receiver.getMap();
        }

        void start() throws Exception {
            this.ch = new JChannel(StateTransferTest.this.props);
            this.ch.connect("StateTransferTest-Group");
            this.receiver = new Receiver(this.ch, this.promise);
            boolean rc = this.ch.getState(null, 10000L);
            if (rc) {
                StateTransferTest.log("state transfer: OK");
            } else if (this.ch.getView().size() == 1) {
                StateTransferTest.log("state transfer: OK");
            } else {
                StateTransferTest.log("state transfer: FAIL");
            }
            this.receiver.setName("Receiver [" + this.from + " - " + this.to + "]");
            this.receiver.start();
            if (rc) {
                this.promise.getResult();
            }
            this.t = new Thread(this);
            this.t.setName("Worker [" + this.from + " - " + this.to + "]");
            this.t.start();
        }

        public void stop() {
            this.ch.close();
        }

        void waitUntilDone() throws InterruptedException {
            this.t.join();
            this.receiver.join();
        }

        public void run() {
            Object[] data = new Object[2];
            StateTransferTest.log("Worker thread started (sending msgs from " + this.from + " to " + this.to + " (excluding " + this.to + ")");
            for (int i = this.from; i < this.to; ++i) {
                data[0] = new Integer(i);
                data[1] = "Value #" + i;
                try {
                    this.ch.send(null, null, (Serializable)data);
                    if (i % 1000 != 0) continue;
                    StateTransferTest.log("sent " + i);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
        }
    }
}

