/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.identity.ui.actions;

import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import org.jboss.logging.Logger;
import org.jboss.portal.api.node.PortalNode;
import org.jboss.portal.api.node.PortalNodeURL;
import org.jboss.portal.common.text.FastURLDecoder;
import org.jboss.portal.core.identity.services.workflow.ValidateEmailService;
import org.jboss.portal.core.identity.ui.IdentityUIUser;
import org.jboss.portal.core.identity.ui.common.IdentityUserBean;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.User;
import org.jboss.portal.portlet.invocation.ActionInvocation;
import org.jboss.portal.server.ServerInvocationContext;
import org.jboss.portlet.JBossActionRequest;
import org.jboss.portlet.JBossActionResponse;
import org.jboss.portlet.JBossRenderRequest;

public class EditProfileAction {
    private String currentUser;
    private String password;
    private String email;
    private WindowState windowState;
    private IdentityUIUser uiUser;
    private IdentityUserBean identityUserBean;
    private ValidateEmailService validateEmailService;
    private static final FastURLDecoder decoder = FastURLDecoder.getUTF8Instance();
    private static final Logger log = Logger.getLogger(EditProfileAction.class);

    public EditProfileAction() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        ExternalContext ectx = ctx.getExternalContext();
        this.currentUser = ectx.getRemoteUser();
        this.uiUser = new IdentityUIUser(this.currentUser);
    }

    public String getCurrentUser() {
        return this.currentUser;
    }

    public void setCurrentUser(String currentUser) {
        this.currentUser = currentUser;
    }

    public IdentityUIUser getUiUser() {
        if (this.uiUser == null) {
            this.uiUser = new IdentityUIUser(this.currentUser);
        }
        return this.uiUser;
    }

    public void setUiUser(IdentityUIUser uiUser) {
        this.uiUser = uiUser;
    }

    public IdentityUserBean getIdentityUserBean() {
        return this.identityUserBean;
    }

    public void setIdentityUserBean(IdentityUserBean identityUserBean) {
        this.identityUserBean = identityUserBean;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public ValidateEmailService getValidateEmailService() {
        return this.validateEmailService;
    }

    public void setValidateEmailService(ValidateEmailService validateEmailService) {
        this.validateEmailService = validateEmailService;
    }

    public String viewStart() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        ExternalContext ectx = ctx.getExternalContext();
        JBossActionResponse response = (JBossActionResponse)ectx.getResponse();
        try {
            if (this.windowState == null) {
                response.setWindowState(WindowState.NORMAL);
            } else {
                response.setWindowState(this.windowState);
            }
        }
        catch (WindowStateException e) {
            log.error((Object)"", (Throwable)e);
        }
        return "start";
    }

    public String userEditProfile() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        ExternalContext ectx = ctx.getExternalContext();
        JBossActionRequest request = (JBossActionRequest)ectx.getRequest();
        this.windowState = request.getWindowState();
        JBossActionResponse response = (JBossActionResponse)ectx.getResponse();
        this.uiUser = new IdentityUIUser(ectx.getRemoteUser());
        try {
            response.setWindowState(WindowState.MAXIMIZED);
        }
        catch (WindowStateException e) {
            log.error((Object)"", (Throwable)e);
        }
        return "editProfile";
    }

    public String getCurrentWindowState() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        ExternalContext ectx = ctx.getExternalContext();
        JBossRenderRequest request = (JBossRenderRequest)ectx.getRequest();
        return request.getWindowState().toString();
    }

    public String adminEditProfile() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        ExternalContext ectx = ctx.getExternalContext();
        Map params = ectx.getRequestParameterMap();
        this.currentUser = params.get("currentUser") != null ? decoder.encode((String)params.get("currentUser")) : null;
        this.windowState = null;
        if (this.currentUser == null) {
            this.currentUser = ectx.getRemoteUser();
        }
        this.uiUser = new IdentityUIUser(this.currentUser);
        return "editProfile";
    }

    public String updateProfile() {
        ResourceBundle bundle;
        FacesContext ctx = FacesContext.getCurrentInstance();
        try {
            User user = this.identityUserBean.findUserByUserName(this.currentUser);
            this.identityUserBean.updateProfile(user, this.uiUser.getAttribute().getProfileAttributes());
        }
        catch (RuntimeException e) {
            bundle = ResourceBundle.getBundle("conf.bundles.Identity", ctx.getViewRoot().getLocale());
            FacesContext.getCurrentInstance().addMessage("status", new FacesMessage(bundle.getString("IDENTITY_EDIT_PROFILE_ERROR")));
            log.error((Object)"", (Throwable)e);
        }
        catch (IdentityException e) {
            bundle = ResourceBundle.getBundle("conf.bundles.Identity", ctx.getViewRoot().getLocale());
            FacesContext.getCurrentInstance().addMessage("status", new FacesMessage(bundle.getString("IDENTITY_EDIT_PROFILE_ERROR")));
            log.error((Object)"", (Throwable)e);
        }
        ActionInvocation rInvocation = (ActionInvocation)((PortletRequest)ctx.getExternalContext().getRequest()).getAttribute("org.jboss.portal.attribute.component_invocation");
        rInvocation.setAttribute("profile", null);
        rInvocation.setAttribute("user", null);
        Object propertyValue = this.uiUser.getAttribute().getValue("locale").getObject();
        if (propertyValue != null) {
            FacesContext.getCurrentInstance().getViewRoot().setLocale(new Locale(propertyValue.toString()));
        }
        this.resetWindowState(ctx);
        return "start";
    }

    public String changePassword() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        ResourceBundle bundle = ResourceBundle.getBundle("conf.bundles.Identity", ctx.getViewRoot().getLocale());
        if (this.password != null) {
            try {
                this.identityUserBean.updatePassword(this.currentUser, this.password);
                ctx.addMessage("status", new FacesMessage(bundle.getString("IDENTITY_EDIT_CHANGE_PASSWOR_STATUS")));
            }
            catch (IdentityException e) {
                log.error((Object)"error while updating password", (Throwable)e);
                ctx.addMessage("status", new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("IDENTITY_EDIT_CHANGE_PASSWORD_ERROR"), ""));
            }
        } else {
            ctx.addMessage("status", new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("IDENTITY_EDIT_CHANGE_PASSWORD_ERROR"), ""));
        }
        this.resetWindowState(ctx);
        return "status";
    }

    public String adminChangePassword() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        ExternalContext ectx = ctx.getExternalContext();
        Map params = ectx.getRequestParameterMap();
        this.currentUser = params.get("currentUser") != null ? decoder.encode((String)params.get("currentUser")) : null;
        return "adminChangePassword";
    }

    public String changeEmail() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        ResourceBundle bundle = ResourceBundle.getBundle("conf.bundles.Identity", ctx.getViewRoot().getLocale());
        if (this.email != null) {
            try {
                User user = this.identityUserBean.findUserByUserName(this.currentUser);
                Locale locale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
                String portalURL = this.getPortalURL();
                String validationStatus = this.validateEmailService.changeEmail(portalURL, user, this.email, locale);
                if ("registration_pending".equals(validationStatus)) {
                    ctx.addMessage("status", new FacesMessage(bundle.getString("IDENTITY_EDIT_CHANGE_EMAIL_STATUS_PENDING")));
                } else {
                    ctx.addMessage("status", new FacesMessage(bundle.getString("IDENTITY_EDIT_CHANGE_EMAIL_STATUS_CHANGED")));
                }
            }
            catch (Exception e) {
                log.error((Object)"error while changing email", (Throwable)e);
                ctx.addMessage("status", new FacesMessage(bundle.getString("IDENTITY_EDIT_CHANGE_EMAIL_ERROR")));
            }
        }
        this.resetWindowState(ctx);
        return "status";
    }

    private void resetWindowState(FacesContext ctx) {
        if (this.windowState != null) {
            try {
                JBossActionResponse response = (JBossActionResponse)ctx.getExternalContext().getResponse();
                response.setWindowState(this.windowState);
            }
            catch (WindowStateException e) {
                log.error((Object)"", (Throwable)e);
            }
        }
    }

    private String getPortalURL() {
        ExternalContext ectx = FacesContext.getCurrentInstance().getExternalContext();
        JBossActionRequest request = (JBossActionRequest)ectx.getRequest();
        JBossActionResponse response = (JBossActionResponse)ectx.getResponse();
        ServerInvocationContext invocationContext = request.getControllerContext().getServerInvocation().getServerContext();
        PortalNode n = request.getPortalNode();
        PortalNodeURL url = response.createRenderURL(n);
        url.setRelative(false);
        String portalURL = url.toString();
        String a = invocationContext.getPortalContextPath();
        int contextPathIndex = portalURL.indexOf(a);
        String cleanPortalURL = portalURL.substring(0, contextPathIndex);
        cleanPortalURL = cleanPortalURL + a;
        return cleanPortalURL;
    }
}

