/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import org.jboss.logging.Logger;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultSchemaResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaResolverFactory;

public class SingletonSchemaResolverFactory
implements SchemaResolverFactory {
    private static final Logger log = Logger.getLogger((Class)SingletonSchemaResolverFactory.class);
    private static final SingletonSchemaResolverFactory singleton = new SingletonSchemaResolverFactory();
    private final DefaultSchemaResolver resolver = new DefaultSchemaResolver();

    public static SingletonSchemaResolverFactory getInstance() {
        return singleton;
    }

    private SingletonSchemaResolverFactory() {
        this.addSchema("urn:jboss:aop-beans:1.0", "org.jboss.aop.microcontainer.beans.xml.AOPBeansSchemaInitializer", Boolean.FALSE);
        this.addSchema("urn:jboss:bean-deployer", "org.jboss.kernel.plugins.deployment.xml.BeanSchemaInitializer", Boolean.FALSE);
        this.addSchema("urn:jboss:bean-deployer:2.0", "org.jboss.kernel.plugins.deployment.xml.BeanSchemaInitializer20", Boolean.FALSE);
        this.addSchema("urn:jboss:javabean:1.0", "org.jboss.kernel.plugins.config.xml.JavaBeanSchemaInitializer", Boolean.FALSE);
    }

    public SchemaBindingResolver getSchemaBindingResolver() {
        return this.resolver;
    }

    protected boolean addSchema(String namespace, String initializer) {
        try {
            this.resolver.addSchemaInitializer(namespace, initializer);
            log.trace((Object)("Mapped initializer '" + namespace + "' to '" + initializer + "'"));
            return true;
        }
        catch (Exception ignored) {
            log.trace((Object)"Ignored: ", (Throwable)ignored);
            return false;
        }
    }

    protected boolean addSchema(String namespace, String initializer, Boolean parseAnnotations) {
        if (!this.addSchema(namespace, initializer)) {
            return false;
        }
        this.setParseAnnotations(namespace, parseAnnotations);
        return true;
    }

    protected boolean addSchema(String namespace, String initializer, String location) {
        if (!this.addSchema(namespace, initializer)) {
            return false;
        }
        try {
            this.resolver.addSchemaLocation(namespace, location);
            log.trace((Object)("Mapped location '" + namespace + "' to '" + location + "'"));
            return true;
        }
        catch (Exception ignored) {
            log.trace((Object)"Ignored: ", (Throwable)ignored);
            return false;
        }
    }

    protected boolean addSchema(String namespace, String initializer, String location, Boolean parseAnnotations) {
        if (!this.addSchema(namespace, initializer, location)) {
            return false;
        }
        this.setParseAnnotations(namespace, parseAnnotations);
        return true;
    }

    protected void setParseAnnotations(String namespace, Boolean parseAnnotations) {
        this.resolver.addSchemaParseAnnotations(namespace, parseAnnotations);
        log.trace((Object)("Parse annotations '" + namespace + "' set to '" + parseAnnotations + "'"));
    }
}

