/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.net;

import java.io.IOException;
import java.net.URL;
import org.jboss.portal.common.net.URLFilter;
import org.jboss.portal.common.net.URLNavigationProvider;
import org.jboss.portal.common.net.URLVisitor;
import org.jboss.portal.common.net.file.FileURLNavigationProvider;
import org.jboss.portal.common.net.jar.JarURLNavigationProvider;
import org.jboss.portal.common.net.vfs.VFSZipURLNavigationProvider;

public class URLNavigator {
    private static final URLNavigationProvider fileNav = new FileURLNavigationProvider();
    private static final URLNavigationProvider jarNav = new JarURLNavigationProvider();
    private static final URLNavigationProvider vfsZipNav = new VFSZipURLNavigationProvider();
    private static final URLFilter NULL_FILTER = new URLFilter(){

        public boolean acceptFile(URL url) {
            return true;
        }

        public boolean acceptDir(URL url) {
            return true;
        }
    };

    public static void visit(URL url, URLVisitor visitor, URLFilter filter) throws IllegalArgumentException, IOException {
        URLNavigationProvider provider = URLNavigator.getProvider(url);
        if (filter == null) {
            filter = NULL_FILTER;
        }
        provider.visit(url, visitor, filter);
    }

    public static void visit(URL url, URLVisitor visitor) throws IOException {
        URLNavigator.visit(url, visitor, null);
    }

    private static URLNavigationProvider getProvider(URL url) throws IllegalArgumentException {
        if (url == null) {
            throw new IllegalArgumentException("Null not accepted");
        }
        String protocol = url.getProtocol();
        if ("file".equals(protocol)) {
            return fileNav;
        }
        if ("jar".equals(protocol)) {
            return jarNav;
        }
        if ("vfsfile".equals(protocol)) {
            return fileNav;
        }
        if ("vfszip".equals(protocol)) {
            return vfsZipNav;
        }
        throw new IllegalArgumentException("Not recognized " + protocol);
    }
}

