/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.deployment.jboss;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServer;
import javax.transaction.TransactionManager;
import javax.xml.parsers.DocumentBuilder;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationBase;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.portal.common.io.IOTools;
import org.jboss.portal.common.xml.NullEntityResolver;
import org.jboss.portal.common.xml.XMLTools;
import org.jboss.portal.core.controller.coordination.CoordinationConfigurator;
import org.jboss.portal.core.deployment.jboss.ObjectDeploymentFactory;
import org.jboss.portal.core.model.content.ContentType;
import org.jboss.portal.core.model.content.spi.ContentProvider;
import org.jboss.portal.core.model.content.spi.handler.ContentHandler;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectContainer;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.jboss.portal.core.model.portal.metadata.BuildContext;
import org.jboss.portal.core.model.portal.metadata.PortalObjectMetaData;
import org.jboss.portal.server.deployment.PortalWebApp;
import org.jboss.portal.server.deployment.jboss.Deployment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;

public class ObjectDeployment
extends Deployment
implements Advised {
    public static final int OVERWRITE_IF_EXISTS = 0;
    public static final int KEEP_IF_EXISTS = 1;
    protected static final Logger log;
    protected boolean isTrace = log.isTraceEnabled();
    protected TransactionManager tm;
    protected ObjectDeploymentFactory factory;
    protected ArrayList<Unit> units;
    private static ClassAdvisor aop$classAdvisor$aop;
    protected transient ClassInstanceAdvisor _instanceAdvisor;
    private static WeakReference aop$MethodInfo_doStart7390365741110132881;

    public ObjectDeployment(URL url, MBeanServer mbeanServer, TransactionManager tm, PortalWebApp pwa, ObjectDeploymentFactory factory) {
        super(url, pwa, mbeanServer);
        this.tm = tm;
        this.factory = factory;
    }

    public void start() throws DeploymentException {
        try {
            this.doStart();
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void org$jboss$portal$core$deployment$jboss$ObjectDeployment$doStart$aop() throws Exception {
        BufferedInputStream in = null;
        try {
            log.debug((Object)("Loading portal metadata from " + this.url));
            in = IOTools.safeBufferedWrapper((InputStream)this.url.openStream());
            DocumentBuilder builder = XMLTools.getDocumentBuilderFactory().newDocumentBuilder();
            EntityResolver entityResolver = this.factory.getPortalObjectEntityResolver();
            if (entityResolver == null) {
                log.debug((Object)("Coult not obtain entity resolver for " + this.url));
                entityResolver = new NullEntityResolver();
            } else {
                log.debug((Object)("Obtained entity resolver " + entityResolver + " for " + this.url));
            }
            builder.setEntityResolver(entityResolver);
            Document doc = builder.parse(in);
            Element deploymentsElt = doc.getDocumentElement();
            List deploymentElts = XMLTools.getChildren((Element)deploymentsElt, (String)"deployment");
            this.units = new ArrayList(deploymentElts.size());
            for (Element deploymentElt : deploymentElts) {
                Unit unit = new Unit();
                Element parentRefElt = XMLTools.getUniqueChild((Element)deploymentElt, (String)"parent-ref", (boolean)false);
                unit.parentRef = parentRefElt == null ? null : PortalObjectId.parse(XMLTools.asString((Element)parentRefElt), PortalObjectPath.LEGACY_FORMAT);
                Element ifExistsElt = XMLTools.getUniqueChild((Element)deploymentElt, (String)"if-exists", (boolean)false);
                unit.ifExists = 1;
                if (ifExistsElt != null) {
                    String ifExists = XMLTools.asString((Element)ifExistsElt);
                    if ("overwrite".equals(ifExists)) {
                        unit.ifExists = 0;
                    } else if ("keep".equals(ifExists)) {
                        unit.ifExists = 1;
                    }
                }
                PortalObjectMetaData metaData = null;
                Element metaDataElt = XMLTools.getUniqueChild((Element)deploymentElt, (String)"portal", (boolean)false);
                if (metaDataElt == null && (metaDataElt = XMLTools.getUniqueChild((Element)deploymentElt, (String)"page", (boolean)false)) == null && (metaDataElt = XMLTools.getUniqueChild((Element)deploymentElt, (String)"window", (boolean)false)) == null) {
                    metaDataElt = XMLTools.getUniqueChild((Element)deploymentElt, (String)"context", (boolean)false);
                }
                if (metaDataElt != null) {
                    metaData = PortalObjectMetaData.buildMetaData(this.factory.contentProviderRegistry, metaDataElt);
                } else {
                    log.debug((Object)"Instances element in -object.xml is not supported anymore");
                }
                if (metaData == null) continue;
                unit.metaData = metaData;
                this.units.add(unit);
            }
            BuildContext portalObjectBuildContext = new BuildContext(){

                public PortalObjectContainer getContainer() {
                    return ObjectDeployment.this.factory.portalObjectContainer;
                }

                public ContentHandler getContentHandler(ContentType contentType) {
                    ContentProvider contentProvider = ObjectDeployment.this.factory.contentProviderRegistry.getContentProvider(contentType);
                    return contentProvider != null ? contentProvider.getHandler() : null;
                }

                public PortalWebApp getPortalWebApp() {
                    return ObjectDeployment.this.pwa;
                }

                public CoordinationConfigurator getCoordinationConfigurator() {
                    return ObjectDeployment.this.factory.getCoordinationConfigurator();
                }
            };
            for (Unit unit : this.units) {
                if (this.isTrace) {
                    log.trace((Object)unit);
                }
                if (!(unit.metaData instanceof PortalObjectMetaData)) continue;
                PortalObjectContainer portalObjectContainer = this.factory.getPortalObjectContainer();
                PortalObjectMetaData portalObjectMD = (PortalObjectMetaData)unit.metaData;
                if (unit.parentRef != null) {
                    log.debug((Object)("Checking existence of parent portal object '" + unit.parentRef + "'"));
                    PortalObject o = portalObjectContainer.getObject(unit.parentRef);
                    if (o instanceof PortalObject) {
                        PortalObject parent = o;
                        boolean create = true;
                        if (parent.getChild(portalObjectMD.getName()) != null) {
                            switch (unit.ifExists) {
                                case 0: {
                                    parent.destroyChild(portalObjectMD.getName());
                                    break;
                                }
                                case 1: {
                                    create = false;
                                }
                            }
                        }
                        if (!create) continue;
                        log.debug((Object)"Building portal object");
                        PortalObject po = portalObjectMD.create(portalObjectBuildContext, parent);
                        unit.ref = po.getId();
                        continue;
                    }
                    if (o != null) continue;
                    log.warn((Object)("Cannot create portal object " + unit.metaData + " because the parent '" + unit.parentRef + "' that the deployment descriptor references does not exist"));
                    continue;
                }
                if (portalObjectContainer.getContext(portalObjectMD.getName()) != null) continue;
                log.debug((Object)"Building portal object");
                PortalObject po = portalObjectMD.create(portalObjectBuildContext, null);
                unit.ref = po.getId();
            }
        }
        catch (Throwable throwable) {
            IOTools.safeClose(in);
            throw throwable;
        }
        IOTools.safeClose((Closeable)in);
    }

    public void stop() throws DeploymentException {
    }

    public ObjectDeploymentFactory getFactory() {
        return this.factory;
    }

    static {
        aop$classAdvisor$aop = AspectManager.instance().getAdvisor(Class.forName("org.jboss.portal.core.deployment.jboss.ObjectDeployment"));
        log = Logger.getLogger(ObjectDeployment.class);
    }

    public Advisor _getAdvisor() {
        return aop$classAdvisor$aop;
    }

    public InstanceAdvisor _getInstanceAdvisor() {
        ObjectDeployment objectDeployment = this;
        synchronized (objectDeployment) {
            if (this._instanceAdvisor == null) {
                this._instanceAdvisor = new ClassInstanceAdvisor((Object)this);
            }
            return this._instanceAdvisor;
        }
    }

    public void _setInstanceAdvisor(InstanceAdvisor instanceAdvisor) {
        ObjectDeployment objectDeployment = this;
        synchronized (objectDeployment) {
            this._instanceAdvisor = (ClassInstanceAdvisor)instanceAdvisor;
        }
    }

    protected void doStart() throws Exception {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_doStart7390365741110132881.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            doStart_7390365741110132881 doStart_73903657411101328812 = new doStart_7390365741110132881(methodInfo, interceptorArray);
            doStart_73903657411101328812.setTargetObject((Object)this);
            doStart_73903657411101328812.typedTargetObject = this;
            doStart_73903657411101328812.setAdvisor((Advisor)aop$classAdvisor$aop);
            doStart_73903657411101328812.invokeNext();
        } else {
            this.org$jboss$portal$core$deployment$jboss$ObjectDeployment$doStart$aop();
        }
    }

    private static class Unit {
        protected int ifExists;
        protected PortalObjectId parentRef;
        protected Object metaData;
        protected PortalObjectId ref;

        private Unit() {
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer("Unit[::ifExists=" + this.ifExists);
            buffer.append(":parentRef=").append(this.parentRef);
            buffer.append(":Metadata=").append(this.metaData).append(":ref=").append(this.ref).append("]");
            return buffer.toString();
        }
    }

    public static class doStart_7390365741110132881
    extends MethodInvocation
    implements Untransformable {
        public ObjectDeployment typedTargetObject;

        public doStart_7390365741110132881(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public doStart_7390365741110132881(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public doStart_7390365741110132881(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public doStart_7390365741110132881() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            this.typedTargetObject.org$jboss$portal$core$deployment$jboss$ObjectDeployment$doStart$aop();
            return null;
        }

        public Invocation copy() {
            doStart_7390365741110132881 doStart_73903657411101328812 = new doStart_7390365741110132881(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            doStart_73903657411101328812.arguments = this.arguments;
            ((InvocationBase)doStart_73903657411101328812).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)doStart_73903657411101328812).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)doStart_73903657411101328812).instanceResolver = ((InvocationBase)this).instanceResolver;
            doStart_73903657411101328812.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)doStart_73903657411101328812).targetObject = ((InvocationBase)this).targetObject;
            return doStart_73903657411101328812;
        }
    }
}

