/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.impl.model.content.generic;

import org.jboss.portal.common.util.CopyOnWriteRegistry;
import org.jboss.portal.core.impl.model.content.InternalContentProviderRegistry;
import org.jboss.portal.core.impl.model.content.generic.InternalGenericContentProvider;
import org.jboss.portal.core.model.CustomizationManager;
import org.jboss.portal.core.model.content.ContentType;
import org.jboss.portal.core.model.content.spi.portlet.ContentPortlet;
import org.jboss.portal.core.model.instance.InstanceContainer;
import org.jboss.portal.security.spi.auth.PortalAuthorizationManagerFactory;

public class GenericContentProviderRegistry {
    private static GenericContentProviderRegistry instance;
    private InstanceContainer instanceContainer;
    private CustomizationManager customizationManager;
    private InternalContentProviderRegistry registry;
    private CopyOnWriteRegistry registrations = new CopyOnWriteRegistry();
    private PortalAuthorizationManagerFactory pamf;

    public static GenericContentProviderRegistry getInstance() {
        return instance;
    }

    public InstanceContainer getInstanceContainer() {
        return this.instanceContainer;
    }

    public void setInstanceContainer(InstanceContainer instanceContainer) {
        this.instanceContainer = instanceContainer;
    }

    public CustomizationManager getCustomizationManager() {
        return this.customizationManager;
    }

    public void setCustomizationManager(CustomizationManager customizationManager) {
        this.customizationManager = customizationManager;
    }

    public InternalContentProviderRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(InternalContentProviderRegistry registry) {
        this.registry = registry;
    }

    public PortalAuthorizationManagerFactory getPortalAuthorizationManagerFactory() {
        return this.pamf;
    }

    public void setPortalAuthorizationManagerFactory(PortalAuthorizationManagerFactory portalAuthorizationManagerFactory) {
        this.pamf = portalAuthorizationManagerFactory;
    }

    public void register(ContentType contentType, ContentPortlet contentPortlet) {
        InternalGenericContentProvider provider = new InternalGenericContentProvider();
        provider.setContentType(contentType.toString());
        provider.setInstanceContainer(this.instanceContainer);
        provider.setDecorateContent(true);
        provider.setContentPortletInfo(contentPortlet);
        provider.setRegistry(this.registry);
        provider.setPortalAuthorizationManagerFactory(this.pamf);
        this.registrations.register((Object)contentType, (Object)provider);
        try {
            provider.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unregister(ContentType contentType) {
        InternalGenericContentProvider provider = (InternalGenericContentProvider)this.registrations.unregister((Object)contentType);
        if (provider != null) {
            provider.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        Class<GenericContentProviderRegistry> clazz = GenericContentProviderRegistry.class;
        synchronized (GenericContentProviderRegistry.class) {
            if (instance != null) {
                throw new IllegalStateException("Already an existing instance of the generic content provider registry");
            }
            instance = this;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        Class<GenericContentProviderRegistry> clazz = GenericContentProviderRegistry.class;
        synchronized (GenericContentProviderRegistry.class) {
            instance = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

