/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.impl.portlet.state;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.Session;
import org.jboss.portal.core.impl.portlet.state.PersistentConsumer;
import org.jboss.portal.core.impl.portlet.state.PersistentPortletStatePersistenceManager;
import org.jboss.portal.jems.hibernate.ContextObject;
import org.jboss.portal.registration.Consumer;
import org.jboss.portal.registration.ConsumerGroup;
import org.jboss.portal.registration.RegistrationException;
import org.jboss.portal.registration.RegistrationStatus;

public class PersistentConsumerGroup
implements ConsumerGroup,
ContextObject {
    private Long key = null;
    private String persistentName;
    private RegistrationStatus persistentStatus;
    private Map relatedConsumers;
    private PersistentPortletStatePersistenceManager context;

    public PersistentConsumerGroup(PersistentPortletStatePersistenceManager context, String name) {
        this.persistentName = name;
        this.relatedConsumers = new HashMap();
        this.persistentStatus = RegistrationStatus.PENDING;
        this.context = context;
    }

    PersistentConsumerGroup() {
        this.persistentName = null;
        this.persistentStatus = null;
        this.relatedConsumers = null;
    }

    public void setContext(Object context) {
        this.context = (PersistentPortletStatePersistenceManager)((Object)context);
    }

    public Long getKey() {
        return this.key;
    }

    public void setKey(Long key) {
        this.key = key;
    }

    public String getPersistentName() {
        return this.persistentName;
    }

    public void setPersistentName(String persistentName) {
        this.persistentName = persistentName;
    }

    public RegistrationStatus getPersistentStatus() {
        return this.persistentStatus;
    }

    public void setPersistentStatus(RegistrationStatus persistentStatus) {
        this.persistentStatus = persistentStatus;
    }

    public Map getRelatedConsumers() {
        return this.relatedConsumers;
    }

    public void setRelatedConsumers(Map relatedConsumers) {
        this.relatedConsumers = relatedConsumers;
    }

    public String getName() {
        return this.persistentName;
    }

    public Collection getConsumers() throws RegistrationException {
        return Collections.unmodifiableCollection(this.relatedConsumers.values());
    }

    public Consumer getConsumer(String consumerId) throws IllegalArgumentException, RegistrationException {
        if (consumerId == null) {
            throw new IllegalArgumentException("No null consumer id accepted");
        }
        return (Consumer)this.relatedConsumers.get(consumerId);
    }

    public void addConsumer(Consumer consumer) throws RegistrationException {
        PersistentConsumer pconsumer = this.validateImplementation(consumer);
        if (this.relatedConsumers.containsKey(consumer.getId())) {
            throw new IllegalArgumentException("Consumer already attached " + consumer.getId());
        }
        Session session = this.context.getCurrentSession();
        this.relatedConsumers.put(consumer.getId(), pconsumer);
        pconsumer.setRelatedGroup(this);
        session.saveOrUpdate((Object)this);
        session.saveOrUpdate((Object)consumer);
    }

    public void removeConsumer(Consumer consumer) throws RegistrationException {
        this.validateImplementation(consumer);
        if (this.relatedConsumers.remove(consumer.getId()) == null) {
            throw new IllegalArgumentException();
        }
    }

    public boolean contains(Consumer consumer) {
        this.validateImplementation(consumer);
        return this.relatedConsumers.containsKey(consumer.getId());
    }

    private PersistentConsumer validateImplementation(Consumer consumer) throws IllegalArgumentException {
        if (consumer == null) {
            throw new IllegalArgumentException();
        }
        if (consumer instanceof PersistentConsumer) {
            return (PersistentConsumer)consumer;
        }
        throw new IllegalArgumentException();
    }

    public boolean isEmpty() {
        return this.relatedConsumers.isEmpty();
    }

    public RegistrationStatus getStatus() {
        return this.persistentStatus;
    }

    public void setStatus(RegistrationStatus status) {
        this.persistentStatus = status;
    }
}

