/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.model.portal.navstate;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.jboss.logging.Logger;
import org.jboss.portal.WindowState;
import org.jboss.portal.common.invocation.AttributeResolver;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.jboss.portal.core.model.portal.navstate.NavigationAttributeResolver;
import org.jboss.portal.core.model.portal.navstate.PageNavigationalState;
import org.jboss.portal.core.model.portal.navstate.WindowNavigationalState;
import org.jboss.portal.core.navstate.NavigationalStateContext;
import org.jboss.portal.core.navstate.NavigationalStateKey;
import org.jboss.portal.core.navstate.NavigationalStateObjectChange;

public class PortalObjectNavigationalStateContext
implements NavigationalStateContext {
    private static final Logger logger = Logger.getLogger(PortalObjectNavigationalStateContext.class);
    private static final String VIEW_ID_KEY = "view_id";
    private AttributeResolver store;
    private LinkedHashMap<NavigationalStateKey, NavigationalStateObjectChange> changes;

    public PortalObjectNavigationalStateContext(ControllerContext ctx, AttributeResolver store) {
        this.store = new NavigationAttributeResolver(ctx.getServerInvocation().getServerContext().getClientRequest());
        HttpServletRequest request = ctx.getServerInvocation().getServerContext().getClientRequest();
    }

    public Set getKeys() {
        Set storeKeys = this.store.getKeys();
        HashSet<String> keys = new HashSet<String>(storeKeys.size() + this.changes.size());
        keys.addAll(storeKeys);
        for (NavigationalStateKey key : this.changes.keySet()) {
            keys.add(key.getId().toString());
        }
        return keys;
    }

    public Object getAttribute(Object attrKey) throws IllegalArgumentException {
        String storeKey = null;
        if (attrKey instanceof NavigationalStateKey) {
            NavigationalStateObjectChange change;
            NavigationalStateKey nsKey = (NavigationalStateKey)attrKey;
            if (this.changes != null && (change = this.changes.get(nsKey)) != null) {
                switch (change.getType()) {
                    case 0: 
                    case 1: {
                        return change.getNewValue();
                    }
                    case 2: {
                        return null;
                    }
                }
            }
            PortalObjectId id = (PortalObjectId)nsKey.getId();
            storeKey = id.toString();
        }
        if (attrKey instanceof String) {
            storeKey = (String)attrKey;
        }
        return this.store.getAttribute((Object)storeKey);
    }

    public void setAttribute(Object attrKey, Object newNS) throws IllegalArgumentException {
        if (attrKey instanceof NavigationalStateKey) {
            PortalObjectId id;
            Object storedNS;
            NavigationalStateObjectChange change;
            NavigationalStateKey wantedKey = (NavigationalStateKey)attrKey;
            Class typeClass = wantedKey.getType();
            if (typeClass != WindowNavigationalState.class && typeClass != PageNavigationalState.class) {
                throw new IllegalArgumentException("Can only set WindowNavigationalSate or PageNavigationalState attributes, was given " + typeClass.getName());
            }
            Object oldNS = null;
            if (this.changes != null && (change = this.changes.get(wantedKey)) != null) {
                this.changes.remove(wantedKey);
                switch (change.getType()) {
                    case 0: 
                    case 1: {
                        oldNS = change.getOldValue();
                    }
                }
            }
            if (oldNS == null && ((storedNS = this.store.getAttribute((Object)(id = (PortalObjectId)wantedKey.getId()).toString())) instanceof WindowNavigationalState || storedNS instanceof PageNavigationalState)) {
                oldNS = storedNS;
            }
            change = newNS == null ? (oldNS != null ? NavigationalStateObjectChange.newDestroy(wantedKey, oldNS) : null) : (oldNS != null ? NavigationalStateObjectChange.newUpdate(wantedKey, oldNS, newNS) : NavigationalStateObjectChange.newCreate(wantedKey, newNS));
            if (change != null) {
                if (this.changes == null) {
                    this.changes = new LinkedHashMap();
                }
                this.changes.put(wantedKey, change);
            }
        }
        if (attrKey instanceof String) {
            this.store.setAttribute(attrKey, newNS);
        }
    }

    public Iterator<NavigationalStateObjectChange> getChanges() {
        if (this.changes == null) {
            return null;
        }
        return this.changes.values().iterator();
    }

    @Override
    public WindowNavigationalState getWindowNavigationalState(String windowId) {
        NavigationalStateKey key = this.createWindowKey(windowId);
        return (WindowNavigationalState)this.getAttribute(key);
    }

    @Override
    public void setWindowNavigationalState(String windowId, WindowNavigationalState windowNavigationalState) {
        NavigationalStateKey key = this.createWindowKey(windowId);
        this.setAttribute(key, windowNavigationalState);
    }

    @Override
    public PageNavigationalState getPageNavigationalState(String pageId) {
        NavigationalStateKey key = this.createPageKey(pageId);
        return (PageNavigationalState)this.getAttribute(key);
    }

    @Override
    public void setPageNavigationalState(String pageId, PageNavigationalState pageNavigationalState) {
        NavigationalStateKey key = this.createPageKey(pageId);
        this.setAttribute(key, pageNavigationalState);
    }

    @Override
    public boolean applyChanges() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        if (this.changes != null && this.changes.size() > 0) {
            NavigationalStateKey maximizedKey = null;
            for (NavigationalStateObjectChange change : this.changes.values()) {
                WindowNavigationalState wns;
                if (change.getNewValue() instanceof WindowNavigationalState && (wns = (WindowNavigationalState)change.getNewValue()).getWindowState().equals((Object)WindowState.MAXIMIZED)) {
                    if (maximizedKey != null) {
                        logger.error((Object)"Two windows are maximized at once, it should not be possible");
                    }
                    maximizedKey = change.getKey();
                }
                PortalObjectId id = (PortalObjectId)change.getKey().getId();
                this.store.setAttribute((Object)id.toString(), change.getNewValue());
            }
            if (maximizedKey != null) {
                Set keys = this.store.getKeys();
                for (Object key : keys) {
                    Object object = this.store.getAttribute(key);
                    if (!(object instanceof WindowNavigationalState)) continue;
                    WindowNavigationalState wns = (WindowNavigationalState)object;
                    if (key.equals(maximizedKey.getId().toString()) || !wns.getWindowState().equals((Object)WindowState.MAXIMIZED)) continue;
                    WindowNavigationalState wns2 = new WindowNavigationalState(WindowState.NORMAL, wns.getMode(), wns.getContentState(), wns.getPublicContentState());
                    this.store.setAttribute(key, (Object)wns2);
                }
            }
            this.changes.clear();
            Integer viewId = (Integer)this.store.getAttribute((Object)VIEW_ID_KEY);
            viewId = viewId == null ? Integer.valueOf(0) : Integer.valueOf(viewId + 1);
            this.store.setAttribute((Object)VIEW_ID_KEY, (Object)viewId);
            return true;
        }
        return false;
    }

    @Override
    public String getViewId() {
        Integer viewId = (Integer)this.store.getAttribute((Object)VIEW_ID_KEY);
        return viewId != null ? viewId.toString() : "0";
    }

    private NavigationalStateKey createWindowKey(String windowId) {
        return new NavigationalStateKey(WindowNavigationalState.class, PortalObjectId.parse(windowId, PortalObjectPath.CANONICAL_FORMAT));
    }

    private NavigationalStateKey createPageKey(String pageId) {
        return new NavigationalStateKey(PageNavigationalState.class, PortalObjectId.parse(pageId, PortalObjectPath.CANONICAL_FORMAT));
    }
}

