/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.core.error;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.osivia.portal.core.error.ErrorDescriptor;
import org.osivia.portal.core.error.GlobalErrorHandler;
import org.osivia.portal.core.utils.URLUtils;

public class ErrorValve
extends ValveBase {
    public void invoke(Request request, Response response) throws IOException, ServletException, IllegalStateException {
        this.getNext().invoke(request, response);
        int httpErrorCode = 0;
        Exception cause = null;
        String message = null;
        HttpServletRequest httpRequest = request.getRequest();
        String dotServerName = request.getServerName().replaceAll("\\.", "-dot-");
        String errorPageUri = System.getProperty("portal.error.host." + dotServerName + ".uri");
        if (errorPageUri == null) {
            errorPageUri = System.getProperty("error.defaultPageUri");
        }
        if (request.getDecodedRequestURI().equals(errorPageUri)) {
            return;
        }
        if (response.getStatus() == 500) {
            httpErrorCode = 500;
            message = "No Stack Trace. Check server.log";
        }
        if (response.getStatus() == 404) {
            httpErrorCode = 404;
            message = "Resource " + request.getDecodedRequestURI() + " not found (error 404).";
        }
        if (response.getStatus() == 403) {
            httpErrorCode = 403;
            message = "Resource " + request.getDecodedRequestURI() + " forbidden (error 403).";
        }
        if (httpErrorCode > 0) {
            cause = (Exception)request.getAttribute("osivia.error_exception");
            String userId = request.getRemoteUser();
            ErrorDescriptor errDescriptor = new ErrorDescriptor(httpErrorCode, cause, message, userId, null);
            if (!(response.getStatus() != 500 && response.getStatus() != 404 || "1".equals(request.getAttribute("osivia.no_redirection")))) {
                long errId = GlobalErrorHandler.getInstance().logError(errDescriptor);
                HashMap<String, String> parameters = new HashMap<String, String>(2);
                parameters.put("err", String.valueOf(errId));
                parameters.put("httpCode", String.valueOf(httpErrorCode));
                String url = URLUtils.createUrl(httpRequest, errorPageUri, parameters);
                response.sendRedirect(url);
            } else if (response.getStatus() == 403 && !"1".equals(request.getAttribute("osivia.no_redirection"))) {
                HashMap<String, String> parameters = new HashMap<String, String>(1);
                parameters.put("httpCode", String.valueOf(httpErrorCode));
                String url = URLUtils.createUrl(httpRequest, errorPageUri, parameters);
                response.sendRedirect(url);
            }
        }
    }
}

