/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.taglib.toutatice;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.taglib.common.ToutaticeSimpleTag;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspException;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.dom4j.io.HTMLWriter;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.directory.v2.service.PersonService;
import org.osivia.portal.api.html.DOM4JUtils;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.core.cms.CMSException;

public class UserTag
extends ToutaticeSimpleTag {
    private String name;
    private boolean linkable = true;
    private boolean showAvatar = true;

    @Override
    protected void doTag(NuxeoController nuxeoController, DocumentDTO document) throws JspException, IOException {
        if (StringUtils.isNotBlank((String)this.name)) {
            Link userLink;
            PersonService personService;
            Person person;
            Element container = DOM4JUtils.generateElement((String)"span", null, null);
            if (this.showAvatar) {
                Element avatar = null;
                try {
                    Link avatarLink = nuxeoController.getUserAvatar(this.name);
                    if (avatarLink != null) {
                        avatar = DOM4JUtils.generateElement((String)"img", (String)"avatar", null);
                        DOM4JUtils.addAttribute((Element)avatar, (String)"src", (String)avatarLink.getUrl());
                        DOM4JUtils.addAttribute((Element)avatar, (String)"alt", (String)"");
                    }
                }
                catch (CMSException avatarLink) {
                    // empty catch block
                }
                if (avatar == null) {
                    avatar = DOM4JUtils.generateElement((String)"span", null, null, (String)"glyphicons glyphicons-user", null);
                }
                container.add(avatar);
            }
            String displayName = (person = (personService = (PersonService)DirServiceFactory.getService(PersonService.class)).getPerson(this.name)) != null && StringUtils.isNotBlank((String)person.getDisplayName()) ? person.getDisplayName() : this.name;
            String url = null;
            if (this.linkable && person != null && (userLink = this.getTagService().getUserProfileLink(nuxeoController, this.name, displayName)) != null) {
                url = userLink.getUrl();
            }
            Element content = StringUtils.isEmpty(url) ? DOM4JUtils.generateElement((String)"span", null, (String)displayName) : DOM4JUtils.generateLinkElement(url, null, null, (String)"no-ajax-link", (String)displayName);
            container.add(content);
            HTMLWriter htmlWriter = new HTMLWriter((Writer)this.getJspContext().getOut());
            htmlWriter.setEscapeText(false);
            htmlWriter.write(container);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLinkable(boolean linkable) {
        this.linkable = linkable;
    }

    public void setShowAvatar(boolean showAvatar) {
        this.showAvatar = showAvatar;
    }
}

