/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hibernate.jbc.cacheprovider;

import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.transaction.TransactionManager;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;
import org.hibernate.cache.TreeCacheProvider;
import org.hibernate.transaction.TransactionManagerLookup;
import org.hibernate.transaction.TransactionManagerLookupFactory;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeCacheMBean;
import org.jboss.hibernate.jbc.cacheprovider.CacheProperties;
import org.jboss.hibernate.jbc.cacheprovider.JBCCache;
import org.jboss.hibernate.jbc.cacheprovider.OptimisticJBCCache;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.tm.TransactionManagerLocator;

public class JmxBoundTreeCacheProvider
extends TreeCacheProvider
implements CacheProvider {
    private static final Logger log = Logger.getLogger(JmxBoundTreeCacheProvider.class);
    private TreeCache cache;
    private boolean optimistic;
    private TransactionManager transactionManager;

    public Cache buildCache(String regionName, Properties properties) throws CacheException {
        CacheProperties cacheProperties = new CacheProperties(properties);
        if (this.optimistic) {
            return new OptimisticJBCCache(this.cache, regionName, cacheProperties);
        }
        return new JBCCache(this.cache, regionName, cacheProperties, this.getTransactionManager(properties));
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public void start(Properties properties) {
        CacheProperties cacheProperties = new CacheProperties(properties);
        try {
            ObjectName mbeanObjectName = new ObjectName(cacheProperties.getCacheObjectName());
            TreeCacheMBean mbean = (TreeCacheMBean)MBeanProxyExt.create(TreeCacheMBean.class, (ObjectName)mbeanObjectName, (MBeanServer)MBeanServerLocator.locateJBoss());
            this.cache = mbean.getInstance();
            if ("OPTIMISTIC".equals(this.cache.getNodeLockingScheme())) {
                this.optimistic = true;
                log.debug((Object)"JBoss Cache is configured for optimistic locking; provided Cache implementations will also implement OptimisticCache");
            }
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void stop() {
    }

    public boolean isOptimistic() {
        return this.optimistic;
    }

    public TreeCache getUnderlyingCache() {
        return this.cache;
    }

    protected TransactionManager getTransactionManager(Properties properties) {
        if (this.transactionManager == null) {
            TransactionManagerLookup transactionManagerLookup = TransactionManagerLookupFactory.getTransactionManagerLookup((Properties)properties);
            this.transactionManager = transactionManagerLookup != null ? transactionManagerLookup.getTransactionManager(properties) : TransactionManagerLocator.getInstance().locate();
        }
        return this.transactionManager;
    }
}

