/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.controller.portlet;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.common.util.MarkupInfo;
import org.jboss.portal.common.util.ParameterMap;
import org.jboss.portal.core.controller.ControllerCommand;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.controller.portlet.InvokePortletCommandFactory;
import org.jboss.portal.core.controller.portlet.PortletContextFactory;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.core.model.portal.command.action.InvokePortletWindowActionCommand;
import org.jboss.portal.core.model.portal.command.action.InvokePortletWindowRenderCommand;
import org.jboss.portal.core.model.portal.command.action.InvokePortletWindowResourceCommand;
import org.jboss.portal.portlet.ActionURL;
import org.jboss.portal.portlet.ContainerURL;
import org.jboss.portal.portlet.ParametersStateString;
import org.jboss.portal.portlet.RenderURL;
import org.jboss.portal.portlet.ResourceURL;
import org.jboss.portal.portlet.StateString;
import org.jboss.portal.portlet.controller.state.PortletPageNavigationalState;
import org.jboss.portal.portlet.impl.spi.AbstractPortletInvocationContext;
import org.jboss.portal.portlet.invocation.ActionInvocation;
import org.jboss.portal.portlet.invocation.PortletInvocation;
import org.jboss.portal.portlet.invocation.RenderInvocation;
import org.jboss.portal.portlet.invocation.ResourceInvocation;
import org.jboss.portal.portlet.spi.PortletInvocationContext;
import org.jboss.portal.server.request.URLContext;
import org.jboss.portal.server.request.URLFormat;

public class PortletInvocationFactory {
    public static InvokePortletCommandFactory createInvokePortletCommandFactory(ControllerContext controllerContext, Window window, PortletPageNavigationalState pageNavigationalState) {
        return new InternalInvokePortletCommandFactory(window, controllerContext, pageNavigationalState);
    }

    public static PortletInvocationContext createInvocationContext(ControllerContext controllerContext, InvokePortletCommandFactory cpc) {
        MarkupInfo markupInfo = (MarkupInfo)controllerContext.getServerInvocation().getResponse().getContentInfo();
        return new ControllerPortletInvocationContext(cpc, controllerContext, markupInfo);
    }

    public static PortletInvocationContext createInvocationContext(ControllerContext controllerContext, Window window, PortletPageNavigationalState pageNavigationalState) {
        InvokePortletCommandFactory ipcf = PortletInvocationFactory.createInvokePortletCommandFactory(controllerContext, window, pageNavigationalState);
        return PortletInvocationFactory.createInvocationContext(controllerContext, ipcf);
    }

    public static ActionInvocation createAction(ControllerContext controllerContext, Mode mode, WindowState windowState, StateString navigationalState, StateString interactionState, ParameterMap form, Window window, Portal portal, PortletPageNavigationalState pageNavigationalState) {
        PortletContextFactory cf = new PortletContextFactory(controllerContext, portal, window);
        InvokePortletCommandFactory cpc = PortletInvocationFactory.createInvokePortletCommandFactory(controllerContext, window, pageNavigationalState);
        return PortletInvocationFactory.createAction(controllerContext, mode, windowState, navigationalState, interactionState, form, cf, cpc);
    }

    public static ActionInvocation createAction(ControllerContext controllerContext, Mode mode, WindowState windowState, StateString navigationalState, StateString interactionState, ParameterMap form, PortletContextFactory cf, InvokePortletCommandFactory cpc) {
        PortletInvocationContext portletInvocationContext = PortletInvocationFactory.createInvocationContext(controllerContext, cpc);
        ActionInvocation action = new ActionInvocation(portletInvocationContext);
        action.setForm((Map)form);
        action.setMode(mode);
        action.setWindowState(windowState);
        action.setNavigationalState(navigationalState);
        action.setInteractionState(interactionState);
        PortletInvocationFactory.contextualize(controllerContext, cf, (PortletInvocation)action);
        return action;
    }

    public static RenderInvocation createRender(ControllerContext controllerContext, Mode mode, WindowState windowState, StateString navigationalState, Window window, Portal portal, PortletPageNavigationalState pageNavigationalState) {
        PortletContextFactory cf = new PortletContextFactory(controllerContext, portal, window);
        InvokePortletCommandFactory cpc = PortletInvocationFactory.createInvokePortletCommandFactory(controllerContext, window, pageNavigationalState);
        RenderInvocation render = PortletInvocationFactory.createRender(controllerContext, mode, windowState, navigationalState, cf, cpc);
        render.setPublicNavigationalState(pageNavigationalState.getPortletPublicNavigationalState(window.getName()));
        return render;
    }

    public static RenderInvocation createRender(ControllerContext controllerContext, Mode mode, WindowState windowState, StateString navigationalState, PortletContextFactory cf, InvokePortletCommandFactory cpc) {
        PortletInvocationContext portletInvocationContext = PortletInvocationFactory.createInvocationContext(controllerContext, cpc);
        RenderInvocation render = new RenderInvocation(portletInvocationContext);
        render.setMode(mode);
        render.setWindowState(windowState);
        render.setNavigationalState(navigationalState);
        PortletInvocationFactory.contextualize(controllerContext, cf, (PortletInvocation)render);
        return render;
    }

    public static void contextualize(ControllerContext controllerContext, PortletContextFactory cf, PortletInvocation invocation) {
        invocation.setAttribute("controller_context", (Object)controllerContext);
        invocation.setSecurityContext(cf.createSecurityContext());
        invocation.setPortalContext(cf.createPortalContext());
        invocation.setWindowContext(cf.createWindowContext());
        invocation.setUserContext(cf.createUserContext());
        invocation.setServerContext(cf.createServerContext());
        invocation.setClientContext(cf.createClientContext());
        if (invocation instanceof ActionInvocation) {
            ActionInvocation action = (ActionInvocation)invocation;
            action.setRequestContext(cf.createRequestContext());
        } else if (invocation instanceof ResourceInvocation) {
            ResourceInvocation resource = (ResourceInvocation)invocation;
            resource.setRequestContext(cf.createRequestContext());
        }
    }

    public static Window getTargetWindow(PortletInvocation action) {
        ControllerPortletInvocationContext cpic = (ControllerPortletInvocationContext)action.getContext();
        InternalInvokePortletCommandFactory iipcf = (InternalInvokePortletCommandFactory)cpic.cmdFactory;
        return iipcf.window;
    }

    public static void contextualize(PortletInvocation action) {
        ControllerPortletInvocationContext cpic = (ControllerPortletInvocationContext)action.getContext();
        Window window = PortletInvocationFactory.getTargetWindow(action);
        PortletInvocationFactory.contextualize(cpic.controllerContext, new PortletContextFactory(cpic.controllerContext, window.getPage().getPortal(), window), action);
    }

    private static class InternalInvokePortletCommandFactory
    implements InvokePortletCommandFactory {
        Window window;
        ControllerContext controllerContext;
        Map<String, String[]> publicNavigationalState;

        public InternalInvokePortletCommandFactory(Window window, ControllerContext controllerContext, PortletPageNavigationalState pageNavigationalState) {
            this.controllerContext = controllerContext;
            this.window = window;
            if (pageNavigationalState != null) {
                this.publicNavigationalState = pageNavigationalState.getPortletPublicNavigationalState(window.getName());
            }
        }

        @Override
        public ControllerCommand createInvokeActionCommand(ActionURL actionURL) {
            return new InvokePortletWindowActionCommand(this.window.getId(), actionURL.getMode(), actionURL.getWindowState(), actionURL.getNavigationalState(), actionURL.getInteractionState(), null);
        }

        @Override
        public ControllerCommand createInvokeRenderCommand(RenderURL renderURL) {
            StateString navigationalState = renderURL.getNavigationalState();
            if (navigationalState instanceof ParametersStateString) {
                ParametersStateString navigationalParameters = (ParametersStateString)navigationalState;
                Map parameters = navigationalParameters.getParameters();
                Map publicChanges = renderURL.getPublicNavigationalStateChanges();
                if (publicChanges != null && publicChanges.size() > 0) {
                    for (Map.Entry entry : publicChanges.entrySet()) {
                        if (((String[])entry.getValue()).length <= 0) continue;
                        parameters.put(entry.getKey(), entry.getValue());
                    }
                }
                if (this.publicNavigationalState != null && this.publicNavigationalState.size() > 0) {
                    for (Map.Entry<Object, Object> entry : this.publicNavigationalState.entrySet()) {
                        String[] value;
                        String name = (String)entry.getKey();
                        if (parameters.containsKey(name) || publicChanges != null && (value = (String[])publicChanges.get(name)) != null && value.length == 0) continue;
                        parameters.put(name, entry.getValue());
                    }
                }
                navigationalState = ParametersStateString.create((Map)parameters);
            }
            return new InvokePortletWindowRenderCommand(this.window.getId(), renderURL.getMode(), renderURL.getWindowState(), navigationalState);
        }

        @Override
        public ControllerCommand createInvokeResourceCommand(ResourceURL resourceURL) {
            return new InvokePortletWindowResourceCommand(this.window.getId(), resourceURL.getCacheability(), resourceURL.getResourceId(), resourceURL.getResourceState(), null);
        }
    }

    public static class ControllerPortletInvocationContext
    extends AbstractPortletInvocationContext {
        private InvokePortletCommandFactory cmdFactory;
        private ControllerContext controllerContext;

        public ControllerPortletInvocationContext(InvokePortletCommandFactory cmdFactory, ControllerContext controllerContext, MarkupInfo markupInfo) {
            super(markupInfo);
            this.cmdFactory = cmdFactory;
            this.controllerContext = controllerContext;
        }

        public HttpServletRequest getClientRequest() throws IllegalStateException {
            return this.controllerContext.getServerInvocation().getServerContext().getClientRequest();
        }

        public HttpServletResponse getClientResponse() throws IllegalStateException {
            return this.controllerContext.getServerInvocation().getServerContext().getClientResponse();
        }

        public String renderURL(ContainerURL containerURL, org.jboss.portal.portlet.URLFormat urlFormat) {
            ControllerCommand cmd = null;
            if (containerURL instanceof ActionURL) {
                cmd = this.cmdFactory.createInvokeActionCommand((ActionURL)containerURL);
            } else if (containerURL instanceof RenderURL) {
                cmd = this.cmdFactory.createInvokeRenderCommand((RenderURL)containerURL);
            } else if (containerURL instanceof ResourceURL) {
                cmd = this.cmdFactory.createInvokeResourceCommand((ResourceURL)containerURL);
            }
            if (cmd == null) {
                throw new IllegalArgumentException("No container url such as " + containerURL + " can be rendered by the core");
            }
            boolean secure = this.controllerContext.getServerInvocation().getServerContext().getURLContext().isSecure();
            if (urlFormat.getWantSecure() != null) {
                secure = urlFormat.getWantSecure();
            }
            boolean authenticated = this.controllerContext.getServerInvocation().getServerContext().getURLContext().isAuthenticated();
            if (urlFormat.getWantAuthenticated() != null) {
                authenticated = urlFormat.getWantAuthenticated();
            }
            boolean relative = true;
            if (urlFormat.getWantRelative() != null) {
                relative = urlFormat.getWantRelative();
            }
            URLContext info = URLContext.newInstance((boolean)secure, (boolean)authenticated);
            return this.controllerContext.renderURL(cmd, info, URLFormat.newInstance((boolean)relative, (boolean)true));
        }
    }
}

