/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.theme.page;

import java.io.Serializable;
import java.util.Map;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.theme.ThemeTools;
import org.jboss.portal.theme.page.DecorationRendererContextImpl;
import org.jboss.portal.theme.page.PortletRendererContextImpl;
import org.jboss.portal.theme.page.WindowResult;
import org.jboss.portal.theme.render.renderer.DecorationRendererContext;
import org.jboss.portal.theme.render.renderer.PortletRendererContext;
import org.jboss.portal.theme.render.renderer.WindowRendererContext;

public final class WindowContext
implements Comparable,
Serializable,
WindowRendererContext {
    private static final long serialVersionUID = -225656969004976637L;
    private final String id;
    private final DecorationRendererContextImpl decoration = new DecorationRendererContextImpl(this);
    private final PortletRendererContextImpl portlet = new PortletRendererContextImpl(this);
    private String regionName;
    private String order;
    final WindowResult result;
    private Boolean regionCms;

    public WindowContext(String id, String regionName, String order, WindowResult result) {
        this.id = id;
        this.regionName = regionName;
        this.order = order;
        this.result = result;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getOrder() {
        return this.order;
    }

    public String getRegionName() {
        return this.regionName;
    }

    @Override
    public WindowState getWindowState() {
        return this.result.getWindowState();
    }

    @Override
    public Mode getMode() {
        return this.result.getMode();
    }

    @Override
    public DecorationRendererContext getDecoration() {
        return this.decoration;
    }

    @Override
    public PortletRendererContext getPortlet() {
        return this.portlet;
    }

    @Override
    public String getProperty(String name) {
        return (String)this.result.getProperties().get(name);
    }

    @Override
    public Map getProperties() {
        return this.result.getProperties();
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public WindowResult getResult() {
        return this.result;
    }

    public Boolean getRegionCms() {
        return this.regionCms;
    }

    public void setRegionCms(Boolean regionCms) {
        this.regionCms = regionCms;
    }

    public int compareTo(Object o) {
        WindowContext that = (WindowContext)o;
        return ThemeTools.compareWindowOrder(this.order, this.id, that.order, that.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WindowContext that = (WindowContext)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "WindowContext[id=" + this.id + ",region=" + this.regionName + ",order=" + this.order + "]";
    }
}

