/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet;

import java.io.Serializable;
import org.jboss.portal.common.util.ParameterValidation;
import org.jboss.portal.portlet.StatefulPortletContext;

public class PortletContext
implements Serializable {
    protected final String id;

    PortletContext(String id) throws IllegalArgumentException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)id, (String)"portlet id", (String)"PortletContext");
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PortletContext) {
            PortletContext that = (PortletContext)o;
            return this.id.equals(that.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return "PortletContext[" + this.id + "]";
    }

    public byte[] getState() {
        return null;
    }

    public static PortletContext createPortletContext(String id, byte[] state) {
        if (state != null && state.length > 0) {
            return new StatefulPortletContext(id, state);
        }
        return new PortletContext(id);
    }

    public static PortletContext createStatefulPortletContext(String id, byte[] state) {
        return new StatefulPortletContext(id, state);
    }

    public static PortletContext createPortletContext(String portletId) {
        return PortletContext.createPortletContext(portletId, null);
    }
}

