/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security.operation;

import java.security.Principal;
import java.util.Calendar;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.logging.Logger;
import org.jboss.security.auth.callback.CallbackHandlerPolicyContextHandler;
import org.jboss.ws.extensions.security.SecurityStore;
import org.jboss.ws.extensions.security.SimplePrincipal;
import org.jboss.ws.extensions.security.auth.callback.UsernameTokenCallbackHandler;
import org.jboss.ws.extensions.security.element.SecurityHeader;
import org.jboss.ws.extensions.security.element.Token;
import org.jboss.ws.extensions.security.element.UsernameToken;
import org.jboss.ws.extensions.security.exception.WSSecurityException;
import org.jboss.ws.extensions.security.nonce.NonceStore;
import org.jboss.ws.extensions.security.operation.TokenOperation;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.invocation.SecurityAdaptor;
import org.jboss.wsf.spi.invocation.SecurityAdaptorFactory;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.w3c.dom.Document;

public class ReceiveUsernameOperation
implements TokenOperation {
    private SecurityHeader header;
    private SecurityStore store;
    private NonceStore nonceStore;
    private static final int TIMESTAMP_FRESHNESS_THRESHOLD = 300;
    private SecurityAdaptorFactory secAdapterfactory;

    public ReceiveUsernameOperation(SecurityHeader header, SecurityStore store, NonceStore nonceStore) {
        this.header = header;
        this.store = store;
        this.nonceStore = nonceStore;
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        this.secAdapterfactory = (SecurityAdaptorFactory)spiProvider.getSPI(SecurityAdaptorFactory.class);
    }

    public void process(Document message, Token token) throws WSSecurityException {
        UsernameToken user = (UsernameToken)token;
        SecurityAdaptor securityAdaptor = this.secAdapterfactory.newSecurityAdapter();
        Logger.getLogger(this.getClass()).info((Object)("Username: " + user.getUsername()));
        Logger.getLogger(this.getClass()).info((Object)("Password: " + user.getPassword()));
        if (user.isDigest()) {
            this.verifyUsernameToken(user);
            UsernameTokenCallbackHandler handler = new UsernameTokenCallbackHandler(user.getNonce(), user.getCreated());
            CallbackHandlerPolicyContextHandler.setCallbackHandler((CallbackHandler)handler);
        }
        securityAdaptor.setPrincipal((Principal)new SimplePrincipal(user.getUsername()));
        securityAdaptor.setCredential((Object)user.getPassword());
    }

    private void verifyUsernameToken(UsernameToken token) throws WSSecurityException {
        String nonce;
        if (token.getCreated() != null) {
            Calendar cal = SimpleTypeBindings.unmarshalDateTime((String)token.getCreated());
            Calendar ref = Calendar.getInstance();
            ref.add(13, -300);
            if (ref.after(cal)) {
                throw new WSSecurityException("Request rejected since a stale timestamp has been provided: " + token.getCreated());
            }
        }
        if ((nonce = token.getNonce()) != null) {
            if (this.nonceStore.hasNonce(nonce)) {
                throw new WSSecurityException("Request rejected since a message with the same nonce has been recently received; nonce = " + nonce);
            }
            this.nonceStore.putNonce(nonce);
        }
    }
}

