/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.identity.services.captcha;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.portal.core.identity.services.captcha.JCaptchaService;

public class ImageCaptchaServlet
extends HttpServlet {
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        byte[] captchaChallenge = null;
        String captchaId = httpServletRequest.getSession().getId();
        try {
            captchaChallenge = JCaptchaService.getChallengeImage(captchaId, httpServletRequest.getLocale());
        }
        catch (IllegalArgumentException e) {
            httpServletResponse.sendError(404);
            return;
        }
        httpServletResponse.setHeader("Cache-Control", "no-store");
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setDateHeader("Expires", 0L);
        httpServletResponse.setContentType("image/jpeg");
        ServletOutputStream responseOutputStream = httpServletResponse.getOutputStream();
        responseOutputStream.write(captchaChallenge);
        responseOutputStream.flush();
        responseOutputStream.close();
    }
}

