/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.util;

import org.jbpm.util.ClassLoaderUtil;

public abstract class EqualsUtil {
    static boolean isInitialized = false;
    static boolean isHibernateInClasspth = true;
    static Class hibernateProxyClass = null;

    public static boolean equals(Object thisObject, Object otherObject) {
        if (thisObject == null || otherObject == null) {
            return false;
        }
        if (EqualsUtil.isProxy(otherObject)) {
            return otherObject.equals(thisObject);
        }
        return otherObject == thisObject;
    }

    static boolean isProxy(Object otherObject) {
        boolean isProxy = false;
        if (!isInitialized) {
            EqualsUtil.initializeHibernateProxyClass();
        }
        if (isHibernateInClasspth) {
            return hibernateProxyClass.isAssignableFrom(otherObject.getClass());
        }
        return isProxy;
    }

    static synchronized void initializeHibernateProxyClass() {
        try {
            hibernateProxyClass = ClassLoaderUtil.getClassLoader().loadClass("org.hibernate.proxy.HibernateProxy");
        }
        catch (ClassNotFoundException e) {
            isHibernateInClasspth = false;
        }
        isInitialized = true;
    }
}

