/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api.liveedit;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.internationalization.Bundle;

public class OnlyofficeLiveEditHelper {
    public static final String ONLYOFFICE_PLUGIN_NAME = "onlyoffice.plugin";
    public static final String ONLYOFFICE_PORTLET_INSTANCE = "osivia-services-onlyoffice-portletInstance";
    private static List<String> documentMimetype = Arrays.asList("text/rtf", "application/rtf", "application/msword", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/vnd.sun.xml.writer", "application/vnd.sun.xml.writer.template", "application/vnd.oasis.opendocument.text", "application/vnd.oasis.opendocument.text-template", "application/wordperfect");
    private static List<String> spreadsheetMimetype = Arrays.asList("text/csv", "text/tsv", "application/vnd.ms-excel", "application/vnd.ms-excel.sheet.macroEnabled.12", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "application/vnd.sun.xml.calc", "application/vnd.sun.xml.calc.template", "application/vnd.oasis.opendocument.spreadsheet", "application/vnd.oasis.opendocument.spreadsheet-template");
    private static List<String> presentationMimetype = Arrays.asList("application/vnd.ms-powerpoint", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.sun.xml.impress", "application/vnd.sun.xml.impress.template", "application/vnd.oasis.opendocument.presentation", "application/vnd.oasis.opendocument.presentation-template");

    public static String getStartOnlyofficePortlerUrl(Bundle bundle, String documentPath, NuxeoController nuxeoController, Boolean withLock) throws PortalException {
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.cms.uri", documentPath);
        windowProperties.put("osivia.hideTitle", "1");
        windowProperties.put("osivia.onlyoffice.withLock", withLock.toString());
        windowProperties.put("osivia.title", bundle.getString("ONLYOFFICE_EDIT"));
        return nuxeoController.getPortalUrlFactory().getStartPortletUrl(nuxeoController.getPortalCtx(), ONLYOFFICE_PORTLET_INSTANCE, windowProperties);
    }

    public static OnlyofficeFileType getFileType(String mimeType) {
        if (documentMimetype.contains(mimeType)) {
            return OnlyofficeFileType.Text;
        }
        if (spreadsheetMimetype.contains(mimeType)) {
            return OnlyofficeFileType.Spreadsheet;
        }
        if (presentationMimetype.contains(mimeType)) {
            return OnlyofficeFileType.Presentation;
        }
        return OnlyofficeFileType.Text;
    }

    public static boolean isMimeTypeSupported(String mimeType) {
        if (documentMimetype.contains(mimeType)) {
            return true;
        }
        if (spreadsheetMimetype.contains(mimeType)) {
            return true;
        }
        return presentationMimetype.contains(mimeType);
    }

    public static enum OnlyofficeFileType {
        Text,
        Spreadsheet,
        Presentation;

    }
}

