/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.core.auth;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Set;
import javax.naming.InitialContext;
import javax.security.auth.login.LoginException;
import javax.security.jacc.PolicyContext;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.TransactionManager;
import org.jboss.portal.common.transaction.Transactions;
import org.jboss.portal.identity.NoSuchUserException;
import org.jboss.portal.identity.Role;
import org.jboss.portal.identity.User;
import org.jboss.security.SimpleGroup;

public class IdentityLoginModule
extends org.jboss.portal.identity.auth.IdentityLoginModule {
    protected Group[] getRoleSets() throws LoginException {
        try {
            TransactionManager tm = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            return (Group[])Transactions.required((TransactionManager)tm, (Transactions.Runnable)new Transactions.Runnable(){

                public Object run() throws Exception {
                    SimpleGroup rolesGroup;
                    block11: {
                        rolesGroup = new SimpleGroup("Roles");
                        if (IdentityLoginModule.this.additionalRole != null) {
                            rolesGroup.addMember(IdentityLoginModule.this.createIdentity(IdentityLoginModule.this.additionalRole));
                        }
                        try {
                            User user = IdentityLoginModule.this.getUserModule().findUserByUserName(IdentityLoginModule.this.getUsername());
                            Set roles = IdentityLoginModule.this.getMembershipModule().getRoles(user);
                            for (Role role : roles) {
                                String roleName = role.getName();
                                try {
                                    Principal p = IdentityLoginModule.this.createIdentity(roleName);
                                    rolesGroup.addMember(p);
                                }
                                catch (Exception e) {
                                    IdentityLoginModule.this.log.debug((Object)("Failed to create principal " + roleName), (Throwable)e);
                                }
                            }
                        }
                        catch (Exception e) {
                            boolean loginError = true;
                            if (e instanceof NoSuchUserException && "1".equals(System.getProperty("sso.undeclared-user"))) {
                                HttpServletRequest request = null;
                                try {
                                    request = (HttpServletRequest)PolicyContext.getContext((String)"javax.servlet.http.HttpServletRequest");
                                }
                                catch (Exception exception) {
                                    IdentityLoginModule.this.log.error((Object)this, (Throwable)e);
                                    throw new RuntimeException(e);
                                }
                                Object ssoSuccess = request.getAttribute("ssoSuccess");
                                if (ssoSuccess != null) {
                                    loginError = false;
                                    rolesGroup.addMember(IdentityLoginModule.this.createIdentity("undeclared-user"));
                                } else {
                                    throw new LoginException(e.toString());
                                }
                            }
                            if (!loginError) break block11;
                            throw new LoginException(e.toString());
                        }
                    }
                    return new Group[]{rolesGroup};
                }
            });
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            throw new LoginException(cause.toString());
        }
    }
}

