/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.aspects.portlet;

import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.jboss.portal.common.util.UUIDGenerator;
import org.jboss.portal.portlet.ParametersStateString;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.PortletInvokerInterceptor;
import org.jboss.portal.portlet.container.PortletContainer;
import org.jboss.portal.portlet.impl.info.ContainerPortletInfo;
import org.jboss.portal.portlet.info.RuntimeOptionInfo;
import org.jboss.portal.portlet.invocation.ActionInvocation;
import org.jboss.portal.portlet.invocation.EventInvocation;
import org.jboss.portal.portlet.invocation.PortletInvocation;
import org.jboss.portal.portlet.invocation.RenderInvocation;
import org.jboss.portal.portlet.invocation.ResourceInvocation;
import org.jboss.portal.portlet.invocation.response.PortletInvocationResponse;
import org.jboss.portal.portlet.invocation.response.UpdateNavigationalStateResponse;

public class RequestAttributeConversationInterceptor
extends PortletInvokerInterceptor {
    private static final UUIDGenerator generator = new UUIDGenerator();
    private static final Comparator<Conversation> evictor = new Comparator<Conversation>(){

        @Override
        public int compare(Conversation o1, Conversation o2) {
            if (o1.creationDateMillis > o2.creationDateMillis) {
                return -1;
            }
            if (o1.creationDateMillis == o2.creationDateMillis) {
                return 0;
            }
            return 1;
        }
    };

    public PortletInvocationResponse invoke(PortletInvocation invocation) throws IllegalArgumentException, PortletInvokerException {
        PortletContainer container = (PortletContainer)invocation.getAttribute("PORTLET_CONTAINER");
        ContainerPortletInfo containerInfo = (ContainerPortletInfo)container.getInfo();
        Map<String, RuntimeOptionInfo> options = containerInfo.getRuntimeOptionsInfo();
        RuntimeOptionInfo scopingOption = options.get("javax.portlet.actionScopedRequestAttributes");
        int maxScope = 0;
        if (scopingOption != null && "true".equals(scopingOption.getValues().get(0))) {
            maxScope = 10;
            List<String> values = scopingOption.getValues();
            if (values.size() >= 3 && "numberOfCachedScopes".equals(values.get(1))) {
                try {
                    maxScope = Integer.parseInt(values.get(2));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        if (maxScope > 0) {
            if (invocation instanceof ActionInvocation) {
                return this.invoke(maxScope, (ActionInvocation)invocation);
            }
            if (invocation instanceof EventInvocation) {
                return this.invoke(maxScope, (EventInvocation)invocation);
            }
            if (invocation instanceof RenderInvocation) {
                return this.invoke((RenderInvocation)invocation);
            }
            if (invocation instanceof ResourceInvocation) {
                return this.invoke((ResourceInvocation)invocation);
            }
            return super.invoke(invocation);
        }
        return super.invoke(invocation);
    }

    private PortletInvocationResponse invoke(int maxScope, ActionInvocation actionInvocation) throws IllegalArgumentException, PortletInvokerException {
        return this.invokeWithConversation(maxScope, new Conversation(), actionInvocation);
    }

    private PortletInvocationResponse invoke(int maxScope, EventInvocation eventInvocation) throws IllegalArgumentException, PortletInvokerException {
        Conversation conversation = this.loadConversation(eventInvocation);
        if (conversation == null || conversation.rendered) {
            conversation = new Conversation();
        }
        return this.invokeWithConversation(maxScope, conversation, eventInvocation);
    }

    private PortletInvocationResponse invoke(RenderInvocation renderInvocation) throws IllegalArgumentException, PortletInvokerException {
        Conversation conversation = this.loadConversation(renderInvocation);
        if (conversation != null) {
            conversation.rendered = true;
            return this.invokeWithConversation(Integer.MAX_VALUE, conversation, renderInvocation);
        }
        return super.invoke(renderInvocation);
    }

    private PortletInvocationResponse invoke(ResourceInvocation resourceInvocation) throws IllegalArgumentException, PortletInvokerException {
        Conversation conversation = this.loadConversation(resourceInvocation);
        if (conversation != null) {
            return this.invokeWithConversation(Integer.MAX_VALUE, conversation, resourceInvocation);
        }
        return super.invoke(resourceInvocation);
    }

    private Conversation loadConversation(PortletInvocation invocation) {
        HttpServletRequest request;
        HttpSession session;
        String id;
        ParametersStateString parameters = (ParametersStateString)invocation.getNavigationalState();
        if (parameters != null && (id = parameters.getValue("javax.portlet.as")) != null && (session = (request = invocation.getDispatchedRequest()).getSession(false)) != null) {
            String key = "org.jboss.portal.portlet.conversation." + id;
            return (Conversation)session.getAttribute(key);
        }
        return null;
    }

    private PortletInvocationResponse invokeWithConversation(int maxScope, Conversation conversation, PortletInvocation invocation) throws IllegalArgumentException, PortletInvokerException {
        invocation.setRequestAttributes(conversation.getAttributes());
        ParametersStateString inNS = (ParametersStateString)invocation.getNavigationalState();
        if (inNS == null) {
            inNS = ParametersStateString.create();
            invocation.setNavigationalState(inNS);
        }
        inNS.setValue("javax.portlet.as", conversation.id);
        PortletInvocationResponse response = super.invoke(invocation);
        if (response instanceof UpdateNavigationalStateResponse) {
            UpdateNavigationalStateResponse update = (UpdateNavigationalStateResponse)response;
            Map<String, Object> attributes = update.getAttributes();
            if (attributes != null && attributes.size() > 0) {
                ParametersStateString outNS = (ParametersStateString)update.getNavigationalState();
                outNS.setValue("javax.portlet.as", conversation.id);
                conversation.setAttributes(attributes);
                if (!conversation.stored && maxScope > 0) {
                    HttpServletRequest request = invocation.getDispatchedRequest();
                    HttpSession session = request.getSession();
                    int size = 0;
                    Enumeration e = session.getAttributeNames();
                    while (e.hasMoreElements()) {
                        String name = (String)e.nextElement();
                        if (!name.startsWith("org.jboss.portal.portlet.conversation.")) continue;
                        ++size;
                    }
                    if (size >= maxScope) {
                        LinkedList<Conversation> allConversations = null;
                        Enumeration e2 = session.getAttributeNames();
                        while (e2.hasMoreElements()) {
                            String name = (String)e2.nextElement();
                            if (!name.startsWith("org.jboss.portal.portlet.conversation.")) continue;
                            if (allConversations == null) {
                                allConversations = new LinkedList<Conversation>();
                            }
                            allConversations.add((Conversation)session.getAttribute(name));
                        }
                        if (allConversations != null) {
                            Collections.sort(allConversations, evictor);
                            while (allConversations.size() >= maxScope) {
                                Conversation toRemove = (Conversation)allConversations.removeLast();
                                String key = "org.jboss.portal.portlet.conversation." + toRemove.id;
                                session.removeAttribute(key);
                            }
                        }
                    }
                    String key = "org.jboss.portal.portlet.conversation." + conversation.id;
                    session.setAttribute(key, (Object)conversation);
                }
            } else if (conversation.stored) {
                HttpServletRequest request = invocation.getDispatchedRequest();
                HttpSession session = request.getSession();
                String key = "org.jboss.portal.portlet.conversation." + conversation.id;
                session.removeAttribute(key);
            }
        }
        return response;
    }

    static /* synthetic */ UUIDGenerator access$400() {
        return generator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Conversation
    implements HttpSessionBindingListener {
        private static final Map<String, Object> EMPTY_ATTRIBUTES = Collections.emptyMap();
        private Map<String, Object> attributes;
        private Map<String, Object> unmodifiableAttributes;
        private final String id = RequestAttributeConversationInterceptor.access$400().generateKey();
        private boolean rendered = false;
        private final long creationDateMillis = System.currentTimeMillis();
        private boolean stored;

        private Conversation() {
            this.attributes = null;
            this.unmodifiableAttributes = EMPTY_ATTRIBUTES;
        }

        private Conversation(Map<String, Object> attributes) {
            this.attributes = new HashMap<String, Object>(attributes);
            this.unmodifiableAttributes = Collections.unmodifiableMap(attributes);
        }

        public Map<String, Object> getAttributes() {
            return this.unmodifiableAttributes;
        }

        public void setAttributes(Map<String, Object> attributes) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Object>(attributes);
                this.unmodifiableAttributes = Collections.unmodifiableMap(this.attributes);
            } else {
                this.attributes.clear();
                this.attributes.putAll(attributes);
            }
        }

        public void valueBound(HttpSessionBindingEvent event) {
            this.stored = true;
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
            this.stored = false;
        }
    }
}

