/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.container.managed;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.portal.portlet.container.managed.ManagedObjectRegistryEvent;
import org.jboss.portal.portlet.container.managed.ManagedObjectRegistryEventListener;

public class ManagedObjectRegistryEventBroadcaster
implements ManagedObjectRegistryEventListener {
    private final List<ManagedObjectRegistryEventListener> listeners = new CopyOnWriteArrayList<ManagedObjectRegistryEventListener>();

    public void addListener(ManagedObjectRegistryEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(ManagedObjectRegistryEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void onEvent(ManagedObjectRegistryEvent event) {
        for (ManagedObjectRegistryEventListener listener : this.listeners) {
            try {
                listener.onEvent(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

