/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.impl.jsr168;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class ContentBuffer {
    private ClosableOutputStream bytes = null;
    private ClosableWriter chars = null;
    private PrintWriter writer = null;
    private String contentType = null;
    private boolean commited = false;

    public byte[] getBytes() {
        if (this.bytes == null) {
            return null;
        }
        return ((ByteArrayOutputStream)this.bytes.out).toByteArray();
    }

    public String getChars() {
        if (this.chars == null) {
            return null;
        }
        return this.chars.writer.toString();
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public PrintWriter getWriter() throws IllegalStateException {
        if (this.bytes != null) {
            throw new IllegalStateException("The window output stream is already used");
        }
        if (this.contentType == null) {
            throw new IllegalStateException("No content type defined");
        }
        if (this.chars == null) {
            this.chars = new ClosableWriter(new StringWriter());
            this.writer = new PrintWriter(this.chars);
        }
        return this.writer;
    }

    public OutputStream getOutputStream() throws IllegalStateException {
        if (this.chars != null) {
            throw new IllegalStateException("The window writer is already used");
        }
        if (this.contentType == null) {
            throw new IllegalStateException("No content type defined");
        }
        if (this.bytes == null) {
            this.bytes = new ClosableOutputStream(new ByteArrayOutputStream());
        }
        return this.bytes;
    }

    public void reset() {
        if (this.commited) {
            throw new IllegalStateException("Cannot reset a commited stream");
        }
        if (this.bytes != null) {
            ((ByteArrayOutputStream)this.bytes.out).reset();
        } else if (this.chars != null) {
            StringWriter sw = (StringWriter)this.chars.writer;
            sw.flush();
            sw.getBuffer().setLength(0);
        }
    }

    public void commit() throws IllegalStateException {
        this.commited = true;
    }

    public boolean isCommited() {
        return this.commited;
    }

    private class ClosableWriter
    extends Writer {
        boolean closed = false;
        final Writer writer;

        public ClosableWriter(Writer writer) {
            this.writer = writer;
        }

        public void write(int c) throws IOException {
            if (this.closed) {
                throw new IOException("Cannot write to a closed writer");
            }
            this.writer.write(c);
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException("Cannot write to a closed writer");
            }
            this.writer.write(cbuf, off, len);
        }

        public void write(String str) throws IOException {
            if (this.closed) {
                throw new IOException("Cannot write to a closed writer");
            }
            this.writer.write(str);
        }

        public void flush() throws IOException {
            if (this.closed) {
                throw new IOException("Cannot flush closed writer");
            }
            ContentBuffer.this.commited = true;
        }

        public void close() throws IOException {
            this.writer.close();
            ContentBuffer.this.commited = true;
            this.closed = true;
        }
    }

    private class ClosableOutputStream
    extends OutputStream {
        boolean closed = false;
        final OutputStream out;

        public ClosableOutputStream(OutputStream out) {
            this.out = out;
        }

        public void write(byte[] b) throws IOException {
            if (this.closed) {
                throw new IOException("Cannot write to a closed stream");
            }
            this.out.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException("Cannot write to a closed stream");
            }
            this.out.write(b, off, len);
        }

        public void write(int b) throws IOException {
            if (this.closed) {
                throw new IOException("Cannot write to a closed stream");
            }
            this.out.write(b);
        }

        public void flush() throws IOException {
            if (this.closed) {
                throw new IOException("Cannot flush a closed stream");
            }
            ContentBuffer.this.commited = true;
        }

        public void close() throws IOException {
            super.close();
            ContentBuffer.this.commited = true;
            this.closed = true;
        }
    }
}

