/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import org.apache.xml.security.keys.KeyInfo;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.extensions.security.SecurityStore;
import org.jboss.ws.extensions.security.Util;
import org.jboss.ws.extensions.security.element.BinarySecurityToken;
import org.jboss.ws.extensions.security.element.DirectReference;
import org.jboss.ws.extensions.security.element.KeyIdentifier;
import org.jboss.ws.extensions.security.element.Reference;
import org.jboss.ws.extensions.security.element.SecurityTokenReference;
import org.jboss.ws.extensions.security.element.X509IssuerSerial;
import org.jboss.ws.extensions.security.element.X509Token;
import org.jboss.ws.extensions.security.exception.SecurityTokenUnavailableException;
import org.jboss.ws.extensions.security.exception.WSSecurityException;
import org.w3c.dom.Element;

public class KeyResolver {
    private HashMap<String, BinarySecurityToken> tokenCache = new HashMap();
    private SecurityStore store;

    public KeyResolver(SecurityStore store) {
        this.store = store;
    }

    private SecurityTokenReference extractSecurityTokenReference(KeyInfo info) throws WSSecurityException {
        Element child = Util.getFirstChildElement(info.getElement());
        if (child == null) {
            throw new WSSecurityException("Empty KeyInfo");
        }
        if (!child.getLocalName().equals("SecurityTokenReference")) {
            throw new WSSecurityException("KeyInfo did not contain expected SecurityTokenReference, instead got: " + child.getLocalName());
        }
        return new SecurityTokenReference(child);
    }

    public void cacheToken(BinarySecurityToken token) {
        this.tokenCache.put(token.getId(), token);
    }

    public BinarySecurityToken resolve(SecurityTokenReference reference) throws WSSecurityException {
        Reference ref = reference.getReference();
        if (ref instanceof DirectReference) {
            DirectReference direct = (DirectReference)ref;
            return this.resolveDirectReference(direct);
        }
        if (ref instanceof KeyIdentifier) {
            KeyIdentifier identifier = (KeyIdentifier)ref;
            return this.resolveKeyIdentifier(identifier);
        }
        if (ref instanceof X509IssuerSerial) {
            X509IssuerSerial issuerSerial = (X509IssuerSerial)ref;
            return this.resolveX509IssuerSerial(issuerSerial);
        }
        throw new NotImplementedException("Currently only DirectReference is supported!");
    }

    private BinarySecurityToken resolveDirectReference(DirectReference direct) throws WSSecurityException {
        String id = direct.getUri().substring(1);
        BinarySecurityToken token = this.tokenCache.get(id);
        if (token == null) {
            throw new SecurityTokenUnavailableException("Could not resolve token id: " + id);
        }
        return token;
    }

    private BinarySecurityToken resolveKeyIdentifier(KeyIdentifier identifier) throws WSSecurityException {
        X509Certificate cert = this.store.getCertificateBySubjectKeyIdentifier(identifier.getIdentifier());
        if (cert == null) {
            throw new SecurityTokenUnavailableException("Could not locate certificate by key identifier");
        }
        return new X509Token(cert, identifier.getDocument());
    }

    private BinarySecurityToken resolveX509IssuerSerial(X509IssuerSerial issuerSerial) throws WSSecurityException {
        X509Certificate cert = this.store.getCertificateByIssuerSerial(issuerSerial.getIssuer(), issuerSerial.getSerial());
        if (cert == null) {
            throw new SecurityTokenUnavailableException("Could not locate certificate by issuer and serial number");
        }
        return new X509Token(cert, issuerSerial.getDocument());
    }

    public X509Certificate resolveCertificate(SecurityTokenReference reference) throws WSSecurityException {
        BinarySecurityToken token = this.resolve(reference);
        if (!(token instanceof X509Token)) {
            throw new WSSecurityException("Expected X509Token, cache contained: " + token.getClass().getName());
        }
        return ((X509Token)token).getCert();
    }

    public PublicKey resolvePublicKey(SecurityTokenReference reference) throws WSSecurityException {
        return this.resolveCertificate(reference).getPublicKey();
    }

    public PrivateKey resolvePrivateKey(SecurityTokenReference reference) throws WSSecurityException {
        return this.store.getPrivateKey(this.resolveCertificate(reference));
    }

    public BinarySecurityToken resolve(KeyInfo info) throws WSSecurityException {
        return this.resolve(this.extractSecurityTokenReference(info));
    }

    public X509Certificate resolveCertificate(KeyInfo info) throws WSSecurityException {
        return this.resolveCertificate(this.extractSecurityTokenReference(info));
    }

    public PublicKey resolvePublicKey(KeyInfo info) throws WSSecurityException {
        return this.resolvePublicKey(this.extractSecurityTokenReference(info));
    }

    public PrivateKey resolvePrivateKey(KeyInfo info) throws WSSecurityException {
        return this.resolvePrivateKey(this.extractSecurityTokenReference(info));
    }
}

