/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.transaction.TransactionManager;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.Modification;
import org.jboss.cache.TransactionEntry;
import org.jboss.cache.TransactionTable;
import org.jboss.cache.TreeCache;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.interceptors.CacheStoreInterceptorMBean;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.marshall.JBCMethodCall;
import org.jgroups.blocks.MethodCall;

public class CacheStoreInterceptor
extends Interceptor
implements CacheStoreInterceptorMBean {
    protected CacheLoaderConfig loaderConfig = null;
    protected TransactionManager tx_mgr = null;
    protected TransactionTable tx_table = null;
    private HashMap m_txStores = new HashMap();
    private Map preparingTxs = new ConcurrentHashMap();
    private long m_cacheStores = 0L;
    protected CacheLoader loader;

    public void setCache(TreeCache cache) {
        super.setCache(cache);
        this.loaderConfig = cache.getCacheLoaderManager().getCacheLoaderConfig();
        this.tx_mgr = cache.getTransactionManager();
        this.tx_table = cache.getTransactionTable();
        this.loader = cache.getCacheLoaderManager().getCacheLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(MethodCall call) throws Throwable {
        Object key;
        Fqn fqn;
        boolean use_tmp_retval;
        Object tmp_retval;
        Object[] args;
        JBCMethodCall m;
        block24: {
            m = (JBCMethodCall)call;
            if (!this.getInvocationContext().isOriginLocal() && this.loaderConfig.isShared()) {
                this.log.trace((Object)"Passing up method call and bypassing this interceptor since the cache loader is shared and this call originated remotely.");
                return super.invoke(m);
            }
            Method meth = m.getMethod();
            args = m.getArgs();
            tmp_retval = null;
            use_tmp_retval = false;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("CacheStoreInterceptor called with meth " + (Object)((Object)m)));
            }
            if (this.tx_mgr == null || this.tx_mgr.getTransaction() == null) break block24;
            this.log.trace((Object)"transactional so don't put stuff in the cloader yet.");
            GlobalTransaction gtx = this.getInvocationContext().getGlobalTransaction();
            switch (m.getMethodId()) {
                case 11: {
                    if (!this.getInvocationContext().isTxHasMods()) {
                        this.log.trace((Object)"Commit called with no modifications; ignoring.");
                        return super.invoke(m);
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Calling loader.commit() for gtx " + gtx));
                    }
                    List fqnsModified = this.getFqnsFromModificationList(this.tx_table.get(gtx).getCacheLoaderModifications());
                    try {
                        this.loader.commit(gtx);
                    }
                    finally {
                        this.preparingTxs.remove(gtx);
                    }
                    if (!this.cache.getUseInterceptorMbeans()) return super.invoke(m);
                    if (!this.statsEnabled) return super.invoke(m);
                    Integer puts = (Integer)this.m_txStores.get(gtx);
                    if (puts != null) {
                        this.m_cacheStores += (long)puts.intValue();
                    }
                    this.m_txStores.remove(gtx);
                    return super.invoke(m);
                }
                case 12: {
                    if (!this.getInvocationContext().isTxHasMods()) {
                        this.log.trace((Object)"Rollback called with no modifications; ignoring.");
                        return super.invoke(m);
                    }
                    if (this.preparingTxs.containsKey(gtx)) {
                        this.preparingTxs.remove(gtx);
                        this.loader.rollback(gtx);
                    }
                    if (!this.cache.getUseInterceptorMbeans()) return super.invoke(m);
                    if (!this.statsEnabled) return super.invoke(m);
                    this.m_txStores.remove(gtx);
                    return super.invoke(m);
                }
                case 10: 
                case 18: {
                    this.prepareCacheLoader(gtx, this.isOnePhaseCommitPrepareMehod(m));
                    return super.invoke(m);
                }
            }
            return super.invoke(m);
        }
        switch (m.getMethodId()) {
            case 5: {
                fqn = (Fqn)args[1];
                this.loader.remove(fqn);
                break;
            }
            case 6: {
                fqn = (Fqn)args[1];
                key = args[2];
                tmp_retval = this.loader.remove(fqn, key);
                use_tmp_retval = true;
                break;
            }
            case 7: {
                fqn = (Fqn)args[1];
                this.loader.removeData(fqn);
                break;
            }
        }
        Object retval = super.invoke(m);
        switch (m.getMethodId()) {
            case 1: 
            case 2: {
                Modification mod = this.convertMethodCallToModification(m);
                this.log.debug((Object)mod);
                fqn = mod.getFqn();
                this.loader.put(Collections.singletonList(mod));
                if (!this.cache.getUseInterceptorMbeans() || !this.statsEnabled) break;
                ++this.m_cacheStores;
                break;
            }
            case 3: {
                fqn = (Fqn)args[1];
                key = args[2];
                Object value = args[3];
                tmp_retval = this.loader.put(fqn, key, value);
                use_tmp_retval = true;
                if (!this.cache.getUseInterceptorMbeans() || !this.statsEnabled) break;
                ++this.m_cacheStores;
                break;
            }
        }
        if (!use_tmp_retval) return retval;
        return tmp_retval;
    }

    private List getFqnsFromModificationList(List modifications) {
        Iterator it = modifications.iterator();
        ArrayList<Fqn> fqnList = new ArrayList<Fqn>();
        while (it.hasNext()) {
            MethodCall mc = (MethodCall)it.next();
            Fqn fqn = this.findFqn(mc.getArgs());
            if (fqn == null || fqnList.contains(fqn)) continue;
            fqnList.add(fqn);
        }
        return fqnList;
    }

    private Fqn findFqn(Object[] o) {
        for (int i = 0; i < o.length; ++i) {
            if (!(o[i] instanceof Fqn)) continue;
            return (Fqn)o[i];
        }
        return null;
    }

    public long getCacheLoaderStores() {
        return this.m_cacheStores;
    }

    public void resetStatistics() {
        this.m_cacheStores = 0L;
    }

    public Map dumpStatistics() {
        HashMap<String, Long> retval = new HashMap<String, Long>();
        retval.put("CacheLoaderStores", new Long(this.m_cacheStores));
        return retval;
    }

    private void prepareCacheLoader(GlobalTransaction gtx, boolean onePhase) throws Exception {
        int txPuts = 0;
        TransactionEntry entry = this.tx_table.get(gtx);
        if (entry == null) {
            throw new Exception("entry for transaction " + gtx + " not found in transaction table");
        }
        List modifications = entry.getCacheLoaderModifications();
        if (modifications.size() == 0) {
            return;
        }
        ArrayList<Modification> cache_loader_modifications = new ArrayList<Modification>();
        Iterator it = modifications.iterator();
        while (it.hasNext()) {
            JBCMethodCall methodCall = (JBCMethodCall)((Object)it.next());
            Modification mod = this.convertMethodCallToModification(methodCall);
            cache_loader_modifications.add(mod);
            if (!this.cache.getUseInterceptorMbeans() || !this.statsEnabled || mod.getType() != 2 && mod.getType() != 3 && mod.getType() != 1) continue;
            ++txPuts;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Converted method calls to cache loader modifications.  List size: " + cache_loader_modifications.size()));
        }
        if (cache_loader_modifications.size() > 0) {
            this.loader.prepare(gtx, cache_loader_modifications, onePhase);
            this.preparingTxs.put(gtx, gtx);
            if (this.cache.getUseInterceptorMbeans() && this.statsEnabled && txPuts > 0) {
                this.m_txStores.put(gtx, new Integer(txPuts));
            }
        }
    }

    protected Modification convertMethodCallToModification(JBCMethodCall methodCall) throws Exception {
        Method method = methodCall.getMethod();
        if (method == null) {
            throw new Exception("method call has no method: " + (Object)((Object)methodCall));
        }
        Object[] args = methodCall.getArgs();
        switch (methodCall.getMethodId()) {
            case 1: {
                return new Modification(2, (Fqn)args[1], (Map)args[2]);
            }
            case 2: {
                return new Modification(3, (Fqn)args[1], (Map)args[2]);
            }
            case 3: {
                return new Modification(1, (Fqn)args[1], args[2], args[3]);
            }
            case 5: {
                return new Modification(4, (Fqn)args[1]);
            }
            case 6: {
                return new Modification(5, (Fqn)args[1], args[2]);
            }
            case 7: {
                return new Modification(6, (Fqn)args[1]);
            }
        }
        throw new Exception("method call " + method.getName() + " cannot be converted to a modification");
    }
}

