/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.registration.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.portal.common.util.ParameterValidation;
import org.jboss.portal.jems.as.system.AbstractJBossService;
import org.jboss.portal.registration.Consumer;
import org.jboss.portal.registration.ConsumerGroup;
import org.jboss.portal.registration.InvalidConsumerDataException;
import org.jboss.portal.registration.NoSuchRegistrationException;
import org.jboss.portal.registration.PropertyDescription;
import org.jboss.portal.registration.Registration;
import org.jboss.portal.registration.RegistrationException;
import org.jboss.portal.registration.RegistrationManager;
import org.jboss.portal.registration.RegistrationPersistenceManager;
import org.jboss.portal.registration.RegistrationPolicy;
import org.jboss.portal.registration.RegistrationStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistrationManagerImpl
extends AbstractJBossService
implements RegistrationManager {
    private static final Logger log = Logger.getLogger(RegistrationManager.class);
    private RegistrationPolicy policy;
    private RegistrationPersistenceManager persistenceManager;

    @Override
    public RegistrationPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public void setPolicy(RegistrationPolicy policy) {
        this.policy = policy;
        policy.setManager(this);
    }

    @Override
    public RegistrationPersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    @Override
    public void setPersistenceManager(RegistrationPersistenceManager persistenceManager) {
        this.persistenceManager = persistenceManager;
    }

    @Override
    public Registration addRegistrationTo(String consumerName, Map registrationProperties, boolean createConsumerIfNeeded) throws RegistrationException {
        String identity = this.policy.getConsumerIdFrom(consumerName, registrationProperties);
        this.policy.validateRegistrationDataFor(registrationProperties, identity);
        Consumer consumer = this.getOrCreateConsumer(identity, createConsumerIfNeeded, consumerName);
        Registration registration = this.persistenceManager.addRegistrationFor(identity, registrationProperties);
        String handle = this.policy.createRegistrationHandleFor(registration.getId());
        registration.setRegistrationHandle(handle);
        return registration;
    }

    @Override
    public Consumer createConsumer(String name) throws RegistrationException, InvalidConsumerDataException {
        this.policy.validateConsumerName(name);
        String identity = this.policy.getConsumerIdFrom(name, Collections.EMPTY_MAP);
        Consumer consumer = this.persistenceManager.createConsumer(identity, name);
        String groupName = this.policy.getAutomaticGroupNameFor(name);
        if (groupName != null) {
            this.addConsumerToGroupNamed(name, groupName, true, false);
        }
        return consumer;
    }

    @Override
    public Consumer addConsumerToGroupNamed(String consumerName, String groupName, boolean createGroupIfNeeded, boolean createConsumerIfNeeded) throws RegistrationException {
        String identity;
        block7: {
            if (createGroupIfNeeded) {
                this.policy.validateConsumerGroupName(groupName);
            }
            if (createConsumerIfNeeded) {
                this.policy.validateConsumerName(consumerName);
            }
            ConsumerGroup group = this.getConsumerGroup(groupName);
            boolean justCreatedGroup = false;
            if (group == null) {
                if (createGroupIfNeeded) {
                    this.createConsumerGroup(groupName);
                    justCreatedGroup = true;
                } else {
                    throw new NoSuchRegistrationException("There is no existing ConsumerGroup named '" + groupName + "'.");
                }
            }
            identity = this.policy.getConsumerIdFrom(consumerName, Collections.EMPTY_MAP);
            try {
                this.getOrCreateConsumer(identity, createConsumerIfNeeded, consumerName);
            }
            catch (NoSuchRegistrationException e) {
                if (!justCreatedGroup) break block7;
                this.removeConsumerGroup(groupName);
            }
        }
        return this.persistenceManager.addConsumerToGroupNamed(identity, groupName);
    }

    @Override
    public ConsumerGroup createConsumerGroup(String groupName) throws RegistrationException {
        this.policy.validateConsumerGroupName(groupName);
        return this.persistenceManager.createConsumerGroup(groupName);
    }

    @Override
    public void removeConsumer(String identity) throws RegistrationException, NoSuchRegistrationException {
        Consumer consumer = this.getOrCreateConsumer(identity, false, null);
        ConsumerGroup group = consumer.getGroup();
        if (group != null) {
            group.removeConsumer(consumer);
        }
        Iterator i = new ArrayList(consumer.getRegistrations()).iterator();
        while (i.hasNext()) {
            this.removeRegistration((Registration)i.next());
        }
        this.persistenceManager.removeConsumer(identity);
    }

    @Override
    public void removeConsumer(Consumer consumer) throws RegistrationException, NoSuchRegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)consumer, (String)"Consumer");
        this.removeConsumer(consumer.getId());
    }

    @Override
    public Consumer getConsumerByIdentity(String identity) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)identity, (String)"identity", null);
        return this.persistenceManager.getConsumerById(identity);
    }

    @Override
    public Consumer getConsumerFor(String registrationHandle) throws RegistrationException {
        return (Consumer)this.getConsumerOrRegistration(registrationHandle, true);
    }

    @Override
    public Registration getRegistration(String registrationHandle) throws RegistrationException {
        return (Registration)this.getConsumerOrRegistration(registrationHandle, false);
    }

    @Override
    public void removeRegistration(String registrationHandle) throws RegistrationException, NoSuchRegistrationException {
        Registration registration = this.getRegistration(registrationHandle);
        if (registration == null) {
            throw new NoSuchRegistrationException("There is no Registration with handle '" + registrationHandle + "'");
        }
        this.removeRegistration(registration);
    }

    @Override
    public void removeRegistration(Registration registration) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)registration, (String)"Registration");
        registration.setStatus(RegistrationStatus.INVALID);
        this.persistenceManager.removeRegistration(registration.getId());
    }

    @Override
    public ConsumerGroup getConsumerGroup(String groupName) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)groupName, (String)"ConsumerGroup name", null);
        return this.persistenceManager.getConsumerGroup(groupName);
    }

    private Consumer getOrCreateConsumer(String identity, boolean createConsumerIfNeeded, String consumerName) throws RegistrationException {
        Consumer consumer = this.getConsumerByIdentity(identity);
        if (consumer == null) {
            if (createConsumerIfNeeded) {
                consumer = this.createConsumer(consumerName);
            } else {
                throw new NoSuchRegistrationException("There is no Consumer named '" + consumerName + "'.");
            }
        }
        return consumer;
    }

    private Object getConsumerOrRegistration(String registrationHandle, boolean getConsumer) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)registrationHandle, (String)"registration handle", null);
        Registration registration = this.persistenceManager.getRegistration(registrationHandle);
        if (registration == null) {
            return null;
        }
        return getConsumer ? registration.getConsumer() : registration;
    }

    @Override
    public Collection getConsumerGroups() {
        return this.persistenceManager.getConsumerGroups();
    }

    @Override
    public void removeConsumerGroup(ConsumerGroup group) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)group, (String)"ConsumerGroup");
        for (Object consumer : group.getConsumers()) {
            this.removeConsumer((Consumer)consumer);
        }
        this.persistenceManager.removeConsumerGroup(group.getName());
    }

    @Override
    public void removeConsumerGroup(String name) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)name, (String)"ConsumerGroup name");
        this.removeConsumerGroup(this.getConsumerGroup(name));
    }

    @Override
    public Collection getConsumers() {
        return this.persistenceManager.getConsumers();
    }

    @Override
    public void clear() throws RegistrationException {
        ArrayList consumers = new ArrayList(this.getConsumers());
        for (Consumer consumer : consumers) {
            this.removeConsumer(consumer);
        }
        ArrayList groups = new ArrayList(this.getConsumerGroups());
        for (ConsumerGroup group : groups) {
            this.removeConsumerGroup(group);
        }
    }

    @Override
    public void propertiesHaveChanged(Map<QName, ? extends PropertyDescription> registrationProperties) {
        log.debug((Object)"Registration properties have changed, existing registrations will be invalidated...");
        Collection registrations = this.persistenceManager.getRegistrations();
        for (Object registration : registrations) {
            Registration reg = (Registration)registration;
            reg.setStatus(RegistrationStatus.PENDING);
        }
        this.policy.setExpectations(registrationProperties);
    }

    @Override
    public void policyUpdatedTo(RegistrationPolicy policy) {
        this.setPolicy(policy);
    }
}

