/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.theme.deployment.jboss;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.management.MBeanServer;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.portal.common.io.IOTools;
import org.jboss.portal.server.deployment.PortalWebApp;
import org.jboss.portal.server.deployment.jboss.Deployment;
import org.jboss.portal.theme.LayoutException;
import org.jboss.portal.theme.LayoutService;
import org.jboss.portal.theme.RuntimeContext;
import org.jboss.portal.theme.deployment.jboss.LayoutFeaturesDeploymentFactory;
import org.jboss.portal.theme.deployment.jboss.RenderSetMetaDataFactory;
import org.jboss.portal.theme.metadata.RenderSetMetaData;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.UnmarshallerFactory;

public class LayoutFeaturesDeployment
extends Deployment {
    private static Logger log = Logger.getLogger(LayoutFeaturesDeployment.class);
    private final LayoutFeaturesDeploymentFactory factory;
    private boolean trace = false;

    public LayoutFeaturesDeployment(URL url, PortalWebApp pwa, MBeanServer mbeanServer, LayoutFeaturesDeploymentFactory factory) {
        super(url, pwa, mbeanServer);
        this.factory = factory;
        this.trace = log.isTraceEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create() throws DeploymentException {
        if (this.trace) {
            log.trace((Object)("create new renderset(s) found in :  " + this.pwa.getId()));
        }
        try {
            block10: {
                block9: {
                    BufferedInputStream stream;
                    block8: {
                        boolean isRenderSet = this.url.toString().endsWith("-renderSet.xml");
                        if (!isRenderSet) break block9;
                        RuntimeContext ctx = new RuntimeContext(this.pwa.getId(), this.pwa.getServletContext(), this.pwa.getContextPath(), this.pwa.getClassLoader());
                        LayoutService layoutService = this.factory.getLayoutService();
                        stream = null;
                        try {
                            stream = IOTools.safeBufferedWrapper((InputStream)this.url.openStream());
                            if (!isRenderSet) break block8;
                            List renderSets = (List)UnmarshallerFactory.newInstance().newUnmarshaller().unmarshal((InputStream)stream, (ObjectModelFactory)new RenderSetMetaDataFactory(), null);
                            for (int i = 0; i < renderSets.size(); ++i) {
                                RenderSetMetaData renderSet = (RenderSetMetaData)renderSets.get(i);
                                layoutService.addRenderSet(ctx, renderSet);
                            }
                        }
                        catch (Throwable throwable) {
                            IOTools.safeClose(stream);
                            throw throwable;
                        }
                    }
                    IOTools.safeClose((Closeable)stream);
                    break block10;
                }
                if (this.trace) {
                    log.trace((Object)("can't handle deployment of url :" + this.url));
                }
            }
            if (this.trace) {
                log.trace((Object)("done creating new renderset(s) found in :  " + this.pwa.getId()));
            }
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    public void destroy() throws DeploymentException {
        if (this.trace) {
            log.trace((Object)("destroying renderset(s) found in :  " + this.pwa.getId()));
        }
        try {
            LayoutService service = this.factory.getLayoutService();
            service.removeRenderSets(this.pwa.getId());
        }
        catch (LayoutException e) {
            throw new DeploymentException((Throwable)e);
        }
        if (this.trace) {
            log.trace((Object)("done destroying renderset(s) found in :  " + this.pwa.getId()));
        }
    }
}

