/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.server;

import org.jboss.portal.common.util.ContentInfo;
import org.jboss.portal.server.ServerInvocationContext;
import org.jboss.portal.server.ServerRequest;
import org.jboss.portal.server.ServerURL;
import org.jboss.portal.server.request.URLContext;
import org.jboss.portal.server.request.URLFormat;

public class ServerResponse {
    protected static final URLFormat DEFAULT_FORMAT = URLFormat.newInstance(true, true);
    protected ServerRequest req;
    protected ContentInfo contentInfo;
    boolean wantSignOut;
    protected ServerInvocationContext invocationCtx;

    public ServerResponse(ServerRequest req, ServerInvocationContext invocationCtx) {
        this.req = req;
        this.invocationCtx = invocationCtx;
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public void setContentInfo(ContentInfo contentInfo) {
        this.contentInfo = contentInfo;
    }

    public boolean getWantSignOut() {
        return this.wantSignOut;
    }

    public void setWantSignOut(boolean wantSignOut) {
        this.wantSignOut = wantSignOut;
    }

    public String renderURL(ServerURL url) {
        return this.invocationCtx.renderURL(url, this.invocationCtx.getURLContext(), DEFAULT_FORMAT);
    }

    public String renderURL(ServerURL url, URLFormat format) {
        if (format == null) {
            format = DEFAULT_FORMAT;
        }
        return this.invocationCtx.renderURL(url, this.invocationCtx.getURLContext(), format);
    }

    public String renderURL(ServerURL url, URLContext context, URLFormat format) {
        if (context == null) {
            context = this.invocationCtx.getURLContext();
        }
        if (format == null) {
            format = DEFAULT_FORMAT;
        }
        return this.invocationCtx.renderURL(url, context, format);
    }

    public String renderURL(ServerURL url, URLContext context) {
        if (context == null) {
            context = this.invocationCtx.getURLContext();
        }
        return this.invocationCtx.renderURL(url, context, DEFAULT_FORMAT);
    }
}

