/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.server.deployment.jboss;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.management.MBeanServer;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.RepositoryClassLoader;
import org.jboss.portal.server.deployment.PortalWebApp;

public class Deployment {
    protected final Logger log = Logger.getLogger(this.getClass());
    protected final URL url;
    protected final PortalWebApp pwa;
    protected final MBeanServer mbeanServer;

    public Deployment(URL url, MBeanServer mbeanServer) {
        this.url = url;
        this.pwa = null;
        this.mbeanServer = mbeanServer;
    }

    public Deployment(URL url, PortalWebApp pwa, MBeanServer mbeanServer) {
        this.url = url;
        this.pwa = pwa;
        this.mbeanServer = mbeanServer;
    }

    public void create() throws DeploymentException {
    }

    public void start() throws DeploymentException {
    }

    public void stop() throws DeploymentException {
    }

    public void destroy() throws DeploymentException {
    }

    public static URL findWEBINFURL(URL warURL) throws DeploymentException {
        try {
            if ("file".equals(warURL.getProtocol())) {
                File f = new File(warURL.getFile());
                if ((f = new File(f, "WEB-INF")).exists()) {
                    return f.toURL();
                }
                return new URL(warURL + "WEB-INF/");
            }
            throw new DeploymentException("Deployment URL not found " + warURL);
        }
        catch (MalformedURLException e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    public static RepositoryClassLoader findRepositoryClassLoader(ClassLoader loader) throws DeploymentException {
        while (loader != null) {
            if (loader instanceof RepositoryClassLoader) {
                return (RepositoryClassLoader)loader;
            }
            loader = loader.getParent();
        }
        throw new DeploymentException("No repository class loader found");
    }
}

