/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.aspects.controller;

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.api.PortalURL;
import org.jboss.portal.core.aspects.controller.node.Navigation;
import org.jboss.portal.core.controller.Controller;
import org.jboss.portal.core.controller.ControllerCommand;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.controller.ControllerInterceptor;
import org.jboss.portal.core.controller.ControllerRequestDispatcher;
import org.jboss.portal.core.controller.ControllerResponse;
import org.jboss.portal.core.controller.command.SignOutCommand;
import org.jboss.portal.core.impl.api.node.PortalNodeImpl;
import org.jboss.portal.core.model.CustomizationManager;
import org.jboss.portal.core.model.instance.command.action.InvokePortletInstanceRenderCommand;
import org.jboss.portal.core.model.instance.command.render.RenderPortletInstanceCommand;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectContainer;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.jboss.portal.core.model.portal.PortalObjectPermission;
import org.jboss.portal.core.model.portal.command.PageCommand;
import org.jboss.portal.core.model.portal.command.action.ImportPageToDashboardCommand;
import org.jboss.portal.core.model.portal.command.render.RenderPageCommand;
import org.jboss.portal.core.model.portal.command.view.ViewContextCommand;
import org.jboss.portal.core.model.portal.command.view.ViewPageCommand;
import org.jboss.portal.core.model.portal.command.view.ViewPortalCommand;
import org.jboss.portal.core.theme.PageRendition;
import org.jboss.portal.identity.User;
import org.jboss.portal.portlet.ParametersStateString;
import org.jboss.portal.portlet.StateString;
import org.jboss.portal.security.PortalPermission;
import org.jboss.portal.security.PortalSecurityException;
import org.jboss.portal.security.spi.auth.PortalAuthorizationManager;
import org.jboss.portal.security.spi.auth.PortalAuthorizationManagerFactory;
import org.jboss.portal.server.config.ServerConfig;
import org.jboss.portal.server.request.URLContext;
import org.jboss.portal.server.request.URLFormat;
import org.jboss.portal.theme.impl.render.dynamic.DynaRenderOptions;
import org.jboss.portal.theme.page.Region;
import org.jboss.portal.theme.page.WindowContext;
import org.jboss.portal.theme.page.WindowResult;

public class PageCustomizerInterceptor
extends ControllerInterceptor {
    private static Logger log = Logger.getLogger(PageCustomizerInterceptor.class);
    private static final PortalObjectId defaultPortalId = PortalObjectId.parse("/", PortalObjectPath.CANONICAL_FORMAT);
    private static PortalObjectId adminPortalId = PortalObjectId.parse("/admin", PortalObjectPath.CANONICAL_FORMAT);
    private String targetContextPath;
    private String headerPath;
    private String tabsPath;
    private String loginNamespace;
    private ServerConfig config;
    private PortalAuthorizationManagerFactory portalAuthorizationManagerFactory;
    private PortalObjectContainer portalObjectContainer;

    public PortalAuthorizationManagerFactory getPortalAuthorizationManagerFactory() {
        return this.portalAuthorizationManagerFactory;
    }

    public void setPortalAuthorizationManagerFactory(PortalAuthorizationManagerFactory portalAuthorizationManagerFactory) {
        this.portalAuthorizationManagerFactory = portalAuthorizationManagerFactory;
    }

    public PortalObjectContainer getPortalObjectContainer() {
        return this.portalObjectContainer;
    }

    public void setPortalObjectContainer(PortalObjectContainer portalObjectContainer) {
        this.portalObjectContainer = portalObjectContainer;
    }

    public ControllerResponse invoke(ControllerCommand cmd) throws Exception {
        ControllerResponse resp = (ControllerResponse)cmd.invokeNext();
        if (resp instanceof PageRendition) {
            String dashboardNav;
            PageCommand rpc;
            String tabbedNav;
            PageRendition rendition = (PageRendition)resp;
            if (cmd instanceof PageCommand && (tabbedNav = this.injectTabbedNav(rpc = (PageCommand)cmd)) != null) {
                HashMap<String, String> windowProps = new HashMap<String, String>();
                windowProps.put("theme.windowRendererId", "emptyRenderer");
                windowProps.put("theme.decorationRendererId", "emptyRenderer");
                windowProps.put("theme.portletRendererId", "emptyRenderer");
                WindowResult res = new WindowResult("", tabbedNav, Collections.EMPTY_MAP, windowProps, null, WindowState.NORMAL, Mode.VIEW);
                WindowContext blah = new WindowContext("BLAH", "navigation", "0", res);
                rendition.getPageResult().addWindowContext(blah);
                Region region = rendition.getPageResult().getRegion2("navigation");
                DynaRenderOptions.NO_AJAX.setOptions(region.getProperties());
            }
            if ((dashboardNav = this.injectDashboardNav(cmd)) != null) {
                HashMap<String, String> windowProps = new HashMap<String, String>();
                windowProps.put("theme.windowRendererId", "emptyRenderer");
                windowProps.put("theme.decorationRendererId", "emptyRenderer");
                windowProps.put("theme.portletRendererId", "emptyRenderer");
                WindowResult res = new WindowResult("", dashboardNav, Collections.EMPTY_MAP, windowProps, null, WindowState.NORMAL, Mode.VIEW);
                WindowContext bluh = new WindowContext("BLUH", "dashboardnav", "0", res);
                rendition.getPageResult().addWindowContext(bluh);
                Region region = rendition.getPageResult().getRegion2("dashboardnav");
                DynaRenderOptions.NO_AJAX.setOptions(region.getProperties());
            }
        }
        return resp;
    }

    public String injectDashboardNav(ControllerCommand cc) {
        ControllerContext controllerCtx = cc.getControllerContext();
        ControllerRequestDispatcher rd = controllerCtx.getRequestDispatcher(this.targetContextPath, this.headerPath);
        if (rd != null) {
            Portal dashboard;
            Controller controller = controllerCtx.getController();
            User user = controllerCtx.getUser();
            rd.setAttribute("org.jboss.portal.header.USER", user);
            Principal principal = controllerCtx.getServerInvocation().getServerContext().getClientRequest().getUserPrincipal();
            rd.setAttribute("org.jboss.portal.header.PRINCIPAL", principal);
            if (principal == null) {
                PortalURLImpl portalURL;
                String configNamespace = this.config.getProperty("core.login.namespace");
                if (this.loginNamespace == null) {
                    this.loginNamespace = configNamespace;
                }
                if (this.loginNamespace != null && !this.loginNamespace.toLowerCase().trim().equals("default")) {
                    ViewContextCommand vcc = new ViewContextCommand(new PortalObjectId(this.loginNamespace, new PortalObjectPath()));
                    portalURL = new PortalURLImpl(vcc, controllerCtx, Boolean.TRUE, null);
                } else {
                    portalURL = new PortalURLImpl(cc, controllerCtx, Boolean.TRUE, null);
                }
                String securedLogin = this.config.getProperty("core.login.secured");
                if (securedLogin != null && "true".equals(securedLogin.toLowerCase())) {
                    portalURL.setSecure(Boolean.TRUE);
                }
                rd.setAttribute("org.jboss.portal.header.LOGIN_URL", portalURL);
            }
            boolean isDashboard = false;
            if (cc instanceof RenderPageCommand) {
                CustomizationManager cm;
                Portal dashboard2;
                RenderPageCommand rpc = (RenderPageCommand)cc;
                Page page = rpc.getPage();
                String pageName = page.getName();
                isDashboard = rpc.isDashboard();
                if (isDashboard) {
                    ParametersStateString navState = ParametersStateString.create();
                    navState.setValue("editPageSelect", pageName);
                    InvokePortletInstanceRenderCommand command = new InvokePortletInstanceRenderCommand("DashboardConfigPortletInstance", (StateString)navState);
                    rd.setAttribute("org.jboss.portal.header.EDIT_DASHBOARD_URL", new PortalURLImpl(command, controllerCtx, null, null));
                } else if (user != null && (dashboard2 = (cm = controller.getCustomizationManager()).getDashboard(user)).getChild(pageName) == null) {
                    ImportPageToDashboardCommand iptdc = new ImportPageToDashboardCommand(page.getId());
                    rd.setAttribute("org.jboss.portal.header.COPY_TO_DASHBOARD_URL", new PortalURLImpl(iptdc, controllerCtx, null, null));
                }
            }
            if (!isDashboard && user != null && (dashboard = controller.getCustomizationManager().getDashboard(user)) != null) {
                ViewPortalCommand vdc = new ViewPortalCommand(dashboard.getId());
                rd.setAttribute("org.jboss.portal.header.DASHBOARD_URL", new PortalURLImpl(vdc, controllerCtx, null, null));
            }
            boolean admin = false;
            if (cc instanceof RenderPageCommand) {
                RenderPageCommand rpc = (RenderPageCommand)cc;
                Portal portalObject = rpc.getPage().getPortal();
                admin = "admin".equalsIgnoreCase(portalObject.getName());
            }
            if (!admin || isDashboard) {
                PortalObjectPermission perm = new PortalObjectPermission(adminPortalId, 1);
                try {
                    if (controller.getPortalAuthorizationManagerFactory().getManager().checkPermission((PortalPermission)perm)) {
                        ViewPageCommand showadmin = new ViewPageCommand(adminPortalId);
                        rd.setAttribute("org.jboss.portal.header.ADMIN_PORTAL_URL", new PortalURLImpl(showadmin, controllerCtx, null, null));
                    }
                }
                catch (PortalSecurityException e) {
                    log.error((Object)"", (Throwable)e);
                }
            }
            if (admin || isDashboard || cc instanceof RenderPortletInstanceCommand) {
                ViewPageCommand vpc = new ViewPageCommand(this.portalObjectContainer.getContext().getDefaultPortal().getId());
                rd.setAttribute("org.jboss.portal.header.DEFAULT_PORTAL_URL", new PortalURLImpl(vpc, controllerCtx, null, null));
            }
            SignOutCommand cmd = new SignOutCommand();
            rd.setAttribute("org.jboss.portal.header.SIGN_OUT_URL", new PortalURLImpl(cmd, controllerCtx, Boolean.FALSE, null));
            rd.include();
            return rd.getMarkup();
        }
        return null;
    }

    public String injectTabbedNav(PageCommand rpc) {
        ControllerContext controllerCtx = rpc.getControllerContext();
        ControllerRequestDispatcher rd = controllerCtx.getRequestDispatcher(this.targetContextPath, this.tabsPath);
        if (rd != null) {
            Page page = rpc.getPage();
            PortalAuthorizationManager pam = this.portalAuthorizationManagerFactory.getManager();
            PortalNodeImpl node = new PortalNodeImpl(pam, (PortalObject)page);
            rd.setAttribute("org.jboss.portal.api.PORTAL_NODE", node);
            rd.setAttribute("org.jboss.portal.api.PORTAL_RUNTIME_CONTEXT", Navigation.getPortalRuntimeContext());
            rd.include();
            return rd.getMarkup();
        }
        return null;
    }

    public String getHeaderPath() {
        return this.headerPath;
    }

    public void setHeaderPath(String headerPath) {
        this.headerPath = headerPath;
    }

    public String getTargetContextPath() {
        return this.targetContextPath;
    }

    public void setTargetContextPath(String context) {
        this.targetContextPath = context;
    }

    public String getTabsPath() {
        return this.tabsPath;
    }

    public void setTabsPath(String tabsPath) {
        this.tabsPath = tabsPath;
    }

    public String getLoginNamespace() {
        return this.loginNamespace;
    }

    public void setLoginNamespace(String loginNamespace) {
        this.loginNamespace = loginNamespace;
    }

    public ServerConfig getConfig() {
        return this.config;
    }

    public void setConfig(ServerConfig config) {
        this.config = config;
    }

    private static class PortalURLImpl
    implements PortalURL {
        private ControllerCommand command;
        private ControllerContext context;
        private Boolean wantAuthenticated;
        private Boolean wantSecure;
        private boolean relative;
        private String value;

        public PortalURLImpl(ControllerCommand command, ControllerContext context, Boolean wantAuthenticated, Boolean wantSecure) {
            this.command = command;
            this.context = context;
            this.wantAuthenticated = wantAuthenticated;
            this.wantSecure = wantSecure;
            this.relative = false;
            this.value = null;
        }

        public void setAuthenticated(Boolean wantAuthenticated) {
            this.wantAuthenticated = wantAuthenticated;
            this.value = null;
        }

        public void setSecure(Boolean wantSecure) {
            this.wantSecure = wantSecure;
            this.value = null;
        }

        public void setRelative(boolean relative) {
            this.relative = relative;
            this.value = null;
        }

        public String toString() {
            if (this.value == null) {
                URLContext urlContext = this.context.getServerInvocation().getServerContext().getURLContext();
                urlContext = urlContext.withAuthenticated(this.wantAuthenticated).withSecured(this.wantSecure);
                this.value = this.context.renderURL(this.command, urlContext, URLFormat.newInstance((boolean)this.relative, (boolean)true));
            }
            return this.value;
        }
    }
}

