/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.impl.model;

import org.jboss.logging.Logger;
import org.jboss.portal.core.impl.model.content.portlet.PortletContent;
import org.jboss.portal.core.model.CustomizationManager;
import org.jboss.portal.core.model.content.Content;
import org.jboss.portal.core.model.instance.Instance;
import org.jboss.portal.core.model.instance.InstanceContainer;
import org.jboss.portal.core.model.portal.Context;
import org.jboss.portal.core.model.portal.DuplicatePortalObjectException;
import org.jboss.portal.core.model.portal.NoSuchPortalObjectException;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectContainer;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.jboss.portal.core.model.portal.PortalObjectPermission;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.identity.RoleModule;
import org.jboss.portal.identity.User;
import org.jboss.portal.identity.UserModule;
import org.jboss.portal.jems.as.system.AbstractJBossService;
import org.jboss.portal.security.PortalPermission;
import org.jboss.portal.security.spi.auth.PortalAuthorizationManager;
import org.jboss.portal.security.spi.auth.PortalAuthorizationManagerFactory;

public class CustomizationManagerService
extends AbstractJBossService
implements CustomizationManager {
    private static final PortalObjectId TEMPLATE_ID = PortalObjectId.parse("/template", PortalObjectPath.CANONICAL_FORMAT);
    private static final Logger log = Logger.getLogger(CustomizationManager.class);
    private String dashboardContextId;
    private InstanceContainer instanceContainer;
    private PortalAuthorizationManagerFactory pamf;
    private UserModule userModule;
    private RoleModule roleModule;
    private PortalObjectContainer portalObjectContainer;

    public PortalObjectContainer getPortalObjectContainer() {
        return this.portalObjectContainer;
    }

    public void setPortalObjectContainer(PortalObjectContainer portalObjectContainer) {
        this.portalObjectContainer = portalObjectContainer;
    }

    public String getDashboardContextId() {
        return this.dashboardContextId;
    }

    public void setDashboardContextId(String dashboardContextId) {
        this.dashboardContextId = dashboardContextId;
    }

    public InstanceContainer getInstanceContainer() {
        return this.instanceContainer;
    }

    public void setInstanceContainer(InstanceContainer instanceContainer) {
        this.instanceContainer = instanceContainer;
    }

    public PortalAuthorizationManagerFactory getPortalAuthorizationManagerFactory() {
        return this.pamf;
    }

    public void setPortalAuthorizationManagerFactory(PortalAuthorizationManagerFactory portalAuthorizationManagerFactory) {
        this.pamf = portalAuthorizationManagerFactory;
    }

    public UserModule getUserModule() {
        return this.userModule;
    }

    public void setUserModule(UserModule userModule) {
        this.userModule = userModule;
    }

    public RoleModule getRoleModule() {
        return this.roleModule;
    }

    public void setRoleModule(RoleModule roleModule) {
        this.roleModule = roleModule;
    }

    protected void createService() throws Exception {
        super.createService();
    }

    protected void destroyService() throws Exception {
        super.destroyService();
    }

    public Instance getInstance(Window window) throws IllegalArgumentException {
        return this.getInstance(window, null);
    }

    public Instance getInstance(Window window, User user) throws IllegalArgumentException {
        if (window == null) {
            throw new IllegalArgumentException("No window provided");
        }
        Content content = window.getContent();
        String instanceId = ((PortletContent)content).getInstanceRef();
        if (instanceId == null) {
            return null;
        }
        Instance instance = this.instanceContainer.getDefinition(instanceId);
        if (instance != null && user != null) {
            String userId = this.getUserId(user);
            if (this.isDashboard(window, user)) {
                String dashboardId = window.getId().toString();
                instance = instance.getCustomization(dashboardId);
            } else {
                instance = instance.getCustomization(userId);
            }
        }
        return instance;
    }

    public boolean isDashboard(PortalObject object, User user) {
        if (object == null) {
            throw new IllegalArgumentException("No null object");
        }
        try {
            PortalAuthorizationManager pam = this.pamf.getManager();
            PortalObjectPermission perm = new PortalObjectPermission(object.getId(), 8);
            return pam.checkPermission((PortalPermission)perm);
        }
        catch (Exception e) {
            log.error((Object)"Cannot check dashboard for", (Throwable)e);
            return false;
        }
    }

    public Portal getDashboard(User user) throws IllegalArgumentException {
        Portal dashboardPortal = null;
        if (user != null) {
            String userId = this.getUserId(user);
            try {
                Context dashboardContext = this.portalObjectContainer.getContext(this.dashboardContextId);
                dashboardPortal = dashboardContext.getPortal(userId);
                if (dashboardPortal == null) {
                    Portal templatePortal = (Portal)this.portalObjectContainer.getObject(TEMPLATE_ID);
                    dashboardPortal = (Portal)templatePortal.copy(dashboardContext, userId, false);
                    this.copy(templatePortal, dashboardContext.getChild(userId));
                }
            }
            catch (DuplicatePortalObjectException e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        return dashboardPortal;
    }

    private void copy(PortalObject from, PortalObject to) {
        PortalAuthorizationManager pam = this.pamf.getManager();
        for (PortalObject portalObject : from.getChildren()) {
            try {
                PortalObjectPermission perm = new PortalObjectPermission(portalObject.getId(), 1);
                if (pam.checkPermission((PortalPermission)perm)) {
                    portalObject.copy(to, portalObject.getName(), false);
                }
                this.copy(portalObject, to.getChild(portalObject.getName()));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (DuplicatePortalObjectException e) {
                e.printStackTrace();
            }
        }
    }

    public void destroyDashboard(String userId) {
        try {
            Context dashboardContext = this.portalObjectContainer.getContext(this.dashboardContextId);
            if (dashboardContext.getChild(userId) != null) {
                dashboardContext.destroyChild(userId);
            }
        }
        catch (NoSuchPortalObjectException e) {
            e.printStackTrace();
        }
    }

    private String getUserId(User user) {
        return user.getUserName();
    }
}

