/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.impl.model.content;

import java.util.Collection;
import org.jboss.portal.common.util.CopyOnWriteRegistry;
import org.jboss.portal.core.impl.model.content.InternalContentProvider;
import org.jboss.portal.core.impl.model.content.InternalContentProviderRegistry;
import org.jboss.portal.core.model.content.ContentType;
import org.jboss.portal.core.model.content.spi.ContentProvider;
import org.jboss.portal.core.model.portal.content.ContentRenderer;

public class ContentProviderRegistryService
implements InternalContentProviderRegistry {
    private static volatile ContentProviderRegistryService instance;
    private final CopyOnWriteRegistry registry = new CopyOnWriteRegistry();

    public static ContentProviderRegistryService getInstance() {
        return instance;
    }

    public void registerContentProvider(InternalContentProvider contentProvider) {
        this.registry.register((Object)contentProvider.registeredContentType, (Object)contentProvider);
    }

    public void unregisterContentProvider(ContentType contentType) {
        this.registry.unregister((Object)contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Class<ContentProviderRegistryService> clazz = ContentProviderRegistryService.class;
        synchronized (ContentProviderRegistryService.class) {
            if (instance != null) {
                throw new IllegalStateException("An instance of the content type registry service already exists");
            }
            instance = this;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Class<ContentProviderRegistryService> clazz = ContentProviderRegistryService.class;
        synchronized (ContentProviderRegistryService.class) {
            instance = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public Collection getContentTypes() {
        return this.registry.getKeys();
    }

    public ContentProvider getContentProvider(ContentType contentType) {
        InternalContentProvider acp = (InternalContentProvider)this.registry.getRegistration((Object)contentType);
        return acp != null ? acp.contentProvider : null;
    }

    public ContentRenderer getRenderer(ContentType contentType) {
        return (InternalContentProvider)this.registry.getRegistration((Object)contentType);
    }
}

