/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.impl.model.instance.persistent;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.exception.ConstraintViolationException;
import org.jboss.portal.common.util.Tools;
import org.jboss.portal.core.impl.model.instance.AbstractInstance;
import org.jboss.portal.core.impl.model.instance.AbstractInstanceCustomization;
import org.jboss.portal.core.impl.model.instance.AbstractInstanceDefinition;
import org.jboss.portal.core.impl.model.instance.InstanceContainerImpl;
import org.jboss.portal.core.impl.model.instance.JBossInstanceContainerContext;
import org.jboss.portal.core.impl.model.instance.persistent.PersistentInstanceCustomization;
import org.jboss.portal.core.impl.model.instance.persistent.PersistentInstanceDefinition;
import org.jboss.portal.core.impl.model.instance.persistent.PersistentRoleSecurityBinding;
import org.jboss.portal.core.model.instance.DuplicateInstanceException;
import org.jboss.portal.core.model.instance.InstanceDefinition;
import org.jboss.portal.core.model.instance.InstancePermission;
import org.jboss.portal.core.model.instance.metadata.InstanceMetaData;
import org.jboss.portal.jems.hibernate.ObjectContextualizer;
import org.jboss.portal.portlet.PortletContext;
import org.jboss.portal.security.PortalPermission;
import org.jboss.portal.security.PortalSecurityException;
import org.jboss.portal.security.RoleSecurityBinding;
import org.jboss.portal.security.spi.auth.PortalAuthorizationManager;
import org.jboss.portal.security.spi.auth.PortalAuthorizationManagerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentInstanceContainerContext
implements JBossInstanceContainerContext {
    private static final Logger log = Logger.getLogger(PersistentInstanceContainerContext.class);
    private static final String BY_INSTANCE_ID_QUERY = "from " + Tools.getShortNameOf(PersistentInstanceDefinition.class) + " where instanceId=:instanceId";
    private static final String FROM_INSTANCE_DEFINITION_IMPL = "from " + Tools.getShortNameOf(PersistentInstanceDefinition.class);
    protected SessionFactory sessionFactory;
    protected String sessionFactoryJNDIName;
    protected ObjectContextualizer contextualizer = new ObjectContextualizer((Object)this);
    protected ConcurrentReaderHashMap cache = new ConcurrentReaderHashMap();
    protected boolean cacheNaturalId;
    private InstanceContainerImpl container;

    @Override
    public InstanceContainerImpl getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(InstanceContainerImpl container) {
        this.container = container;
    }

    public void flushNaturalIdCache() {
        this.cache.clear();
    }

    public int getNaturalIdCacheSize() {
        return this.cache.size();
    }

    public boolean getCacheNaturalId() {
        return this.cacheNaturalId;
    }

    public void setCacheNaturalId(boolean cacheNaturalId) {
        this.cacheNaturalId = cacheNaturalId;
    }

    public String getSessionFactoryJNDIName() {
        return this.sessionFactoryJNDIName;
    }

    public void setSessionFactoryJNDIName(String sessionFactoryJNDIName) {
        this.sessionFactoryJNDIName = sessionFactoryJNDIName;
    }

    public void start() throws Exception {
        this.sessionFactory = (SessionFactory)new InitialContext().lookup(this.sessionFactoryJNDIName);
        this.contextualizer.attach(this.sessionFactory);
    }

    public void stop() throws Exception {
        this.sessionFactory = null;
    }

    @Override
    public Collection<InstanceDefinition> getInstanceDefinitions() {
        Session session = this.sessionFactory.getCurrentSession();
        return session.createQuery(FROM_INSTANCE_DEFINITION_IMPL).list();
    }

    @Override
    public AbstractInstanceCustomization newInstanceCustomization(AbstractInstanceDefinition def, String id, PortletContext portletContext) {
        return new PersistentInstanceCustomization((PersistentInstanceDefinition)def, id, portletContext);
    }

    @Override
    public AbstractInstanceDefinition newInstanceDefinition(String id, String portletRef) {
        return new PersistentInstanceDefinition(this, id, portletRef);
    }

    @Override
    public AbstractInstanceDefinition newInstanceDefinition(InstanceMetaData instanceMetaData) {
        return new PersistentInstanceDefinition(this, instanceMetaData);
    }

    @Override
    public AbstractInstanceDefinition getInstanceDefinition(String id) {
        PersistentInstanceDefinition instance;
        Long pk = this.cacheNaturalId ? (Long)this.cache.get((Object)id) : null;
        Session session = this.sessionFactory.getCurrentSession();
        if (pk == null) {
            instance = this.lookupNoCache((org.hibernate.Session)session, id);
        } else {
            instance = (PersistentInstanceDefinition)session.get(PersistentInstanceDefinition.class, (Serializable)pk);
            if (instance == null) {
                instance = this.lookupNoCache((org.hibernate.Session)session, id);
            }
        }
        if (this.cacheNaturalId) {
            if (instance != null) {
                this.cache.put((Object)id, (Object)instance.getKey());
            } else {
                this.cache.remove((Object)id);
            }
        }
        return instance;
    }

    @Override
    public AbstractInstanceCustomization getCustomization(AbstractInstanceDefinition instanceDef, String customizationId) {
        PersistentInstanceDefinition _instanceDef = (PersistentInstanceDefinition)instanceDef;
        return (PersistentInstanceCustomization)_instanceDef.relatedCustomizations.get(customizationId);
    }

    private PersistentInstanceDefinition lookupNoCache(org.hibernate.Session session, String id) {
        Query q = session.createQuery(BY_INSTANCE_ID_QUERY);
        q.setString("instanceId", id);
        return (PersistentInstanceDefinition)q.uniqueResult();
    }

    @Override
    public void createInstanceDefinition(AbstractInstanceDefinition instanceDef) throws DuplicateInstanceException {
        String id = instanceDef.getId();
        if (this.getInstanceDefinition(id) != null) {
            throw new DuplicateInstanceException("An instance with id " + id + " already exist");
        }
        try {
            Session session = this.sessionFactory.getCurrentSession();
            session.persist((Object)instanceDef);
        }
        catch (ConstraintViolationException e) {
            throw new DuplicateInstanceException("An instance with id " + id + " already exist");
        }
    }

    @Override
    public void createInstanceCustomizaton(AbstractInstanceCustomization customization) {
        this.createInstanceCustomizaton((PersistentInstanceCustomization)customization);
    }

    private void createInstanceCustomizaton(PersistentInstanceCustomization customization) {
        Session session = this.sessionFactory.getCurrentSession();
        session.persist((Object)customization);
        PersistentInstanceDefinition relatedDefinition = customization.owner;
        relatedDefinition.relatedCustomizations.put(customization.customizationId, customization);
        customization.relatedDefinition = relatedDefinition;
        session.update((Object)customization.relatedDefinition);
        customization.persistent = true;
    }

    private void updateInstance(AbstractInstance instanceDef) {
        Session session = this.sessionFactory.getCurrentSession();
        session.update((Object)instanceDef);
    }

    @Override
    public void updateInstance(AbstractInstance instance, PortletContext portletContext, boolean mutable) {
        PersistentInstanceDefinition _instance = (PersistentInstanceDefinition)instance;
        _instance.setPortletRef(portletContext.getId());
        _instance.setState(portletContext.getState());
        _instance.setMutable(mutable);
        this.updateInstance(_instance);
    }

    @Override
    public void updateInstance(AbstractInstance instance, PortletContext portletContext) {
        instance.setPortletRef(portletContext.getId());
        instance.setState(portletContext.getState());
        this.updateInstance(instance);
    }

    @Override
    public void updateInstanceDefinition(AbstractInstanceDefinition def, Set securityBindings) {
        PersistentInstanceDefinition _def = (PersistentInstanceDefinition)def;
        Iterator<Object> i = _def.getRelatedSecurityBindings().values().iterator();
        while (i.hasNext()) {
            PersistentRoleSecurityBinding isc = (PersistentRoleSecurityBinding)i.next();
            i.remove();
            isc.setInstance(null);
        }
        for (RoleSecurityBinding sc : securityBindings) {
            PersistentRoleSecurityBinding isc = new PersistentRoleSecurityBinding(sc.getActions(), sc.getRoleName());
            isc.setInstance(_def);
            _def.getRelatedSecurityBindings().put(sc.getRoleName(), isc);
        }
    }

    @Override
    public void destroyInstanceDefinition(AbstractInstanceDefinition instanceDef) {
        this.destroyInstanceDefinition((PersistentInstanceDefinition)instanceDef);
    }

    private void destroyInstanceDefinition(PersistentInstanceDefinition instanceDef) {
        Session session = this.sessionFactory.getCurrentSession();
        Collection customizations = instanceDef.getRelatedCustomizations().values();
        Iterator i = customizations.iterator();
        while (i.hasNext()) {
            PersistentInstanceCustomization userInstance = (PersistentInstanceCustomization)i.next();
            i.remove();
            userInstance.relatedDefinition = null;
            session.delete((Object)userInstance);
        }
        session.delete((Object)instanceDef);
        session.flush();
    }

    @Override
    public void destroyInstanceCustomization(AbstractInstanceCustomization customization) {
        this.destroyInstanceCustomization((PersistentInstanceCustomization)customization);
    }

    private void destroyInstanceCustomization(PersistentInstanceCustomization customization) {
        Session session = this.sessionFactory.getCurrentSession();
        customization.relatedDefinition.relatedCustomizations.remove(customization.getId());
        customization.relatedDefinition = null;
        session.delete((Object)customization);
        session.flush();
    }

    @Override
    public boolean checkPermission(InstancePermission perm) {
        if (this.container.getPerformSecurityChecks()) {
            boolean result = false;
            try {
                PortalAuthorizationManagerFactory pamf = this.container.getPortalAuthorizationManagerFactory();
                PortalAuthorizationManager manager = pamf.getManager();
                result = manager.checkPermission((PortalPermission)perm);
            }
            catch (PortalSecurityException e) {
                log.error((Object)"Cannot check instance permission", (Throwable)e);
            }
            return result;
        }
        return true;
    }
}

