/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.model.portal.command.action;

import java.util.Map;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.common.util.ParameterMap;
import org.jboss.portal.core.controller.ControllerCommand;
import org.jboss.portal.core.controller.ControllerException;
import org.jboss.portal.core.controller.NoSuchResourceException;
import org.jboss.portal.core.controller.command.info.ActionCommandInfo;
import org.jboss.portal.core.controller.command.info.CommandInfo;
import org.jboss.portal.core.controller.portlet.ControllerPageNavigationalState;
import org.jboss.portal.core.controller.portlet.ControllerPortletControllerContext;
import org.jboss.portal.core.controller.portlet.ControllerResponseFactory;
import org.jboss.portal.core.model.content.Content;
import org.jboss.portal.core.model.instance.Instance;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.core.model.portal.command.action.InvokePortletWindowCommand;
import org.jboss.portal.core.model.portal.navstate.PageNavigationalState;
import org.jboss.portal.core.navstate.NavigationalStateContext;
import org.jboss.portal.identity.User;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.StateString;
import org.jboss.portal.portlet.controller.PortletController;
import org.jboss.portal.portlet.controller.PortletControllerContext;
import org.jboss.portal.portlet.controller.request.ContainerRequest;
import org.jboss.portal.portlet.controller.request.ControllerRequest;
import org.jboss.portal.portlet.controller.request.PortletActionRequest;
import org.jboss.portal.portlet.controller.response.ControllerResponse;
import org.jboss.portal.portlet.controller.response.PageUpdateResponse;
import org.jboss.portal.portlet.controller.response.PortletResponse;
import org.jboss.portal.portlet.controller.state.PortletPageNavigationalState;
import org.jboss.portal.portlet.controller.state.PortletWindowNavigationalState;
import org.jboss.portal.portlet.info.PortletInfo;

public class InvokePortletWindowActionCommand
extends InvokePortletWindowCommand {
    private static final CommandInfo info = new ActionCommandInfo(false);
    private StateString interactionState;
    private ParameterMap formParameters;
    protected Instance instance;

    public InvokePortletWindowActionCommand(PortalObjectId windowId, Mode mode, WindowState windowState, StateString navigationalState, StateString interactionState, ParameterMap formParameters) throws IllegalArgumentException {
        super(windowId, mode, windowState, navigationalState);
        this.interactionState = interactionState;
        this.formParameters = formParameters;
    }

    public StateString getInteractionState() {
        return this.interactionState;
    }

    public void setInteractionState(StateString interactionState) {
        this.interactionState = interactionState;
    }

    public ParameterMap getFormParameters() {
        return this.formParameters;
    }

    public void setFormParameters(ParameterMap formParameters) {
        this.formParameters = formParameters;
    }

    public CommandInfo getInfo() {
        return info;
    }

    public void acquireResources() throws NoSuchResourceException {
        super.acquireResources();
        this.instance = this.getInstance(this.window);
        if (this.instance == null) {
            String ref = null;
            Content content = this.window.getContent();
            if (content != null) {
                ref = content.getURI();
            }
            if (ref == null) {
                ref = this.window.getId().toString();
            }
            throw new NoSuchResourceException(ref);
        }
    }

    private Instance getInstance(Window window) {
        User user = this.getControllerContext().getUser();
        return this.context.getController().getCustomizationManager().getInstance(window, user);
    }

    protected ContainerRequest createPortletRequest(PortletInfo portletInfo, PortletPageNavigationalState pageNS, PortletWindowNavigationalState windowNS) {
        return new PortletActionRequest(this.window.getName(), this.interactionState, (Map)this.formParameters, windowNS, pageNS);
    }

    public org.jboss.portal.core.controller.ControllerResponse execute() throws ControllerException {
        try {
            ControllerPortletControllerContext cpcc = new ControllerPortletControllerContext(this.context, this.page);
            ControllerPageNavigationalState pageNS = cpcc.getStateControllerContext().createPortletPageNavigationalState(false);
            PortletWindowNavigationalState windowNS = pageNS.getPortletWindowNavigationalState(this.window.getName());
            PortletInfo portletInfo = cpcc.getPortletInfo(this.window.getName());
            ContainerRequest containerRequest = this.createPortletRequest(portletInfo, pageNS, windowNS);
            PortletController controller = new PortletController();
            ControllerResponse cr = controller.process((PortletControllerContext)cpcc, (ControllerRequest)containerRequest);
            PortletResponse portletResponse = (PortletResponse)cr;
            if (cr instanceof PageUpdateResponse) {
                PageUpdateResponse pageUpdate = (PageUpdateResponse)cr;
                ControllerPageNavigationalState pageNavigationalState = (ControllerPageNavigationalState)pageUpdate.getPageNavigationalState();
                pageNavigationalState.flushUpdates();
            }
            NavigationalStateContext ctx = (NavigationalStateContext)cpcc.getControllerContext().getAttributeResolver(ControllerCommand.NAVIGATIONAL_STATE_SCOPE);
            PageNavigationalState pns = ctx.getPageNavigationalState(this.page.getId().toString());
            return ControllerResponseFactory.createActionResponse(this.targetId, portletResponse.getResponse(), portletInfo, pns);
        }
        catch (PortletInvokerException e) {
            return ControllerResponseFactory.createResponse(e);
        }
    }
}

