/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.model.portal.metadata;

import org.jboss.portal.common.xml.XMLTools;
import org.jboss.portal.core.model.content.spi.ContentProviderRegistry;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectContainer;
import org.jboss.portal.core.model.portal.metadata.BuildContext;
import org.jboss.portal.core.model.portal.metadata.PortalMetaData;
import org.jboss.portal.core.model.portal.metadata.PortalObjectMetaData;
import org.w3c.dom.Element;

public class ContextMetaData
extends PortalObjectMetaData {
    protected PortalObject newInstance(BuildContext buildContext, PortalObject parent) throws Exception {
        PortalObjectContainer portalObjectContainer = buildContext.getContainer();
        String namespace = this.getName();
        return portalObjectContainer.createContext(namespace);
    }

    public static ContextMetaData buildContextMetaData(ContentProviderRegistry contentProviderRegistry, Element contextElt) throws Exception {
        ContextMetaData contextMD = new ContextMetaData();
        String contextName = XMLTools.asString((Element)XMLTools.getUniqueChild((Element)contextElt, (String)"context-name", (boolean)true));
        if (contextName == null || contextName.indexOf(".") >= 0 || contextName.indexOf(":") >= 0) {
            throw new IllegalArgumentException("Invalid context-name: '" + contextName + "'. Must not be null and must not contain a '.' or ':'");
        }
        contextMD.setName(contextName);
        for (Element portalElt : XMLTools.getChildren((Element)contextElt, (String)"portal")) {
            PortalMetaData pageMD = (PortalMetaData)PortalObjectMetaData.buildMetaData(contentProviderRegistry, portalElt);
            contextMD.getChildren().put(pageMD.getName(), pageMD);
        }
        return contextMD;
    }
}

