/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.model.portal.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.portal.WindowState;
import org.jboss.portal.common.xml.XMLTools;
import org.jboss.portal.core.model.content.spi.ContentProviderRegistry;
import org.jboss.portal.core.model.portal.PageContainer;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.metadata.BuildContext;
import org.jboss.portal.core.model.portal.metadata.PortalObjectMetaData;
import org.jboss.portal.core.model.portal.metadata.WindowMetaData;
import org.jboss.portal.core.model.portal.metadata.coordination.CoordinationMetaData;
import org.w3c.dom.Element;

public class PageMetaData
extends PortalObjectMetaData {
    private static final Logger logger = Logger.getLogger(PageMetaData.class);
    private CoordinationMetaData coordinationMetaData;

    protected PortalObject newInstance(BuildContext buildContext, PortalObject parent) throws Exception {
        if (!(parent instanceof PageContainer)) {
            throw new IllegalArgumentException("Cannot build page " + this.getName() + " because the parent it references is not a page container " + parent);
        }
        return ((PageContainer)parent).createPage(this.getName());
    }

    public static PageMetaData buildPageMetaData(ContentProviderRegistry contentProviderRegistry, Element pageElt) {
        PageMetaData pageMD = new PageMetaData();
        String pageName = XMLTools.asString((Element)XMLTools.getUniqueChild((Element)pageElt, (String)"page-name", (boolean)true));
        pageMD.setName(pageName);
        List windowElts = XMLTools.getChildren((Element)pageElt, (String)"window");
        for (int j = 0; j < windowElts.size(); ++j) {
            Element windowElt = (Element)windowElts.get(j);
            try {
                WindowMetaData windowMD = (WindowMetaData)PortalObjectMetaData.buildMetaData(contentProviderRegistry, windowElt);
                pageMD.getChildren().put(windowMD.getName(), windowMD);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        PageMetaData.checkConstraints(pageMD);
        List pageElts = XMLTools.getChildren((Element)pageElt, (String)"page");
        for (int j = 0; j < pageElts.size(); ++j) {
            Element childPageElt = (Element)pageElts.get(j);
            try {
                PageMetaData childPageMD = (PageMetaData)PortalObjectMetaData.buildMetaData(contentProviderRegistry, childPageElt);
                pageMD.getChildren().put(childPageMD.getName(), childPageMD);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Element coordinationElt = XMLTools.getUniqueChild((Element)pageElt, (String)"coordination", (boolean)false);
        if (coordinationElt != null) {
            pageMD.setCoordinationMetaData(CoordinationMetaData.buildMetaData(coordinationElt));
        }
        return pageMD;
    }

    private void setCoordinationMetaData(CoordinationMetaData coordinationMetaData) {
        this.coordinationMetaData = coordinationMetaData;
    }

    public CoordinationMetaData getCoordinationMetaData() {
        return this.coordinationMetaData;
    }

    private static boolean checkConstraints(PageMetaData pageMD) {
        Collection<PortalObjectMetaData> values = pageMD.getChildren().values();
        ArrayList<WindowMetaData> maximizedWindows = new ArrayList<WindowMetaData>();
        if (values != null) {
            for (PortalObjectMetaData poMetaData : values) {
                if (!(poMetaData instanceof WindowMetaData)) continue;
                WindowMetaData windowMetaData = (WindowMetaData)poMetaData;
                if (!WindowState.MAXIMIZED.toString().equals(windowMetaData.getInitialWindowState())) continue;
                maximizedWindows.add(windowMetaData);
                if (maximizedWindows.size() <= 1) continue;
                logger.debug((Object)("Set initial window state to NORMAL for window '" + windowMetaData + "'"));
                windowMetaData.setInitialWindowState(WindowState.NORMAL.toString());
            }
        }
        if (maximizedWindows.size() > 1) {
            StringBuffer windowsList = new StringBuffer();
            for (WindowMetaData windowMD : maximizedWindows) {
                windowsList.append(windowMD.toString() + "\n");
            }
            logger.error((Object)("More than one window is defined as maximized for page '" + pageMD.getName() + "'. The following windows" + " have been defined as maximized:\n" + windowsList));
            return false;
        }
        return true;
    }

    public String toString() {
        return "Page[" + this.getName() + "]";
    }
}

