/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.model.portal.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.portal.common.i18n.LocaleFormat;
import org.jboss.portal.common.i18n.LocalizedString;
import org.jboss.portal.common.i18n.ResourceBundleManager;
import org.jboss.portal.common.util.ConversionException;
import org.jboss.portal.common.util.Tools;
import org.jboss.portal.common.xml.XMLTools;
import org.jboss.portal.core.model.MetaDataResourceBundleFactory;
import org.jboss.portal.core.model.content.spi.ContentProviderRegistry;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectContainer;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.jboss.portal.core.model.portal.metadata.BuildContext;
import org.jboss.portal.core.model.portal.metadata.ContextMetaData;
import org.jboss.portal.core.model.portal.metadata.PageMetaData;
import org.jboss.portal.core.model.portal.metadata.PortalMetaData;
import org.jboss.portal.core.model.portal.metadata.WindowMetaData;
import org.jboss.portal.core.model.portal.metadata.coordination.CoordinationMetaData;
import org.jboss.portal.security.RoleSecurityBinding;
import org.jboss.portal.security.SecurityConstants;
import org.jboss.portal.security.metadata.SecurityConstraintsMetaData;
import org.jboss.portal.security.spi.provider.DomainConfigurator;
import org.jboss.portal.security.spi.provider.SecurityConfigurationException;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PortalObjectMetaData {
    private static Logger log = Logger.getLogger(PortalObjectMetaData.class);
    private String name;
    private String listener;
    private Map<String, String> properties = new HashMap<String, String>();
    private Map<String, PortalObjectMetaData> children = new HashMap<String, PortalObjectMetaData>();
    private SecurityConstraintsMetaData securityConstraints;
    private LocalizedString displayName;
    private String resourceBundle;
    private List supportedLocales;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getListener() {
        return this.listener;
    }

    public void setListener(String listener) {
        this.listener = listener;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public Map<String, PortalObjectMetaData> getChildren() {
        return this.children;
    }

    public void setChildren(Map children) {
        this.children = children;
    }

    public void setDisplayName(LocalizedString displayName) {
        this.displayName = displayName;
    }

    public LocalizedString getDisplayName() {
        return this.displayName;
    }

    public SecurityConstraintsMetaData getSecurityConstraints() {
        return this.securityConstraints;
    }

    public void setSecurityConstraints(SecurityConstraintsMetaData securityConstraints) {
        this.securityConstraints = securityConstraints;
    }

    public final PortalObject create(BuildContext buildContext, PortalObject parent) throws Exception {
        PortalObject object = this.newInstance(buildContext, parent);
        this.configure(buildContext, object);
        for (PortalObjectMetaData portalObjectMD : this.getChildren().values()) {
            portalObjectMD.create(buildContext, object);
        }
        CoordinationMetaData coordinationMD = null;
        if (this instanceof PortalMetaData) {
            coordinationMD = ((PortalMetaData)this).getCoordinationMetaData();
        } else if (this instanceof PageMetaData) {
            coordinationMD = ((PageMetaData)this).getCoordinationMetaData();
        }
        if (coordinationMD != null) {
            coordinationMD.configure(buildContext, object);
        }
        return object;
    }

    protected abstract PortalObject newInstance(BuildContext var1, PortalObject var2) throws Exception;

    private void configure(BuildContext buildContext, PortalObject object) throws SecurityConfigurationException {
        SecurityConstraintsMetaData securityConstraints;
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            object.setDeclaredProperty(entry.getKey(), entry.getValue());
        }
        object.setListener(this.listener);
        if (this.resourceBundle != null) {
            ClassLoader classloader = null;
            classloader = buildContext.getPortalWebApp() != null ? buildContext.getPortalWebApp().getClassLoader() : Thread.currentThread().getContextClassLoader();
            ResourceBundleManager bundleMgr = MetaDataResourceBundleFactory.createResourceBundleManager(classloader, this.supportedLocales, this.resourceBundle);
            object.setDisplayName(bundleMgr.getLocalizedValue("org.jboss.portal.object.name." + object.getId().getPath().toString(PortalObjectPath.LEGACY_FORMAT), object.getName()));
        }
        if (this.displayName != null) {
            object.setDisplayName(this.displayName);
        }
        if ((securityConstraints = this.getSecurityConstraints()) == null) {
            RoleSecurityBinding binding;
            if (this instanceof PortalMetaData) {
                securityConstraints = new SecurityConstraintsMetaData();
                binding = new RoleSecurityBinding("viewrecursive", SecurityConstants.UNCHECKED_ROLE_NAME);
                securityConstraints.getConstraints().add(binding);
            } else if (this instanceof ContextMetaData) {
                securityConstraints = new SecurityConstraintsMetaData();
                binding = new RoleSecurityBinding("view", SecurityConstants.UNCHECKED_ROLE_NAME);
                securityConstraints.getConstraints().add(binding);
            }
        } else if (this instanceof WindowMetaData) {
            securityConstraints = null;
            log.warn((Object)("Window " + this.getName() + " has security a " + "configuration but it is not taken in account, portlet instance configuration should be done rather"));
        }
        if (securityConstraints != null) {
            PortalObjectContainer poc = buildContext.getContainer();
            DomainConfigurator domainConfigurator = poc.getAuthorizationDomain().getConfigurator();
            domainConfigurator.setSecurityBindings(object.getId().toString(PortalObjectPath.CANONICAL_FORMAT), securityConstraints.getConstraints());
        }
    }

    public static PortalObjectMetaData buildMetaData(ContentProviderRegistry contentProviderRegistry, Element portalObjectElt) throws Exception {
        String type = portalObjectElt.getTagName();
        PortalObjectMetaData portalObjectMD = null;
        if ("portal".equals(type)) {
            portalObjectMD = PortalMetaData.buildPortalMetaData(contentProviderRegistry, portalObjectElt);
        } else if ("page".equals(type)) {
            portalObjectMD = PageMetaData.buildPageMetaData(contentProviderRegistry, portalObjectElt);
        } else if ("window".equals(type)) {
            portalObjectMD = WindowMetaData.buildPortletWindowMetaData(contentProviderRegistry, portalObjectElt);
        } else if ("context".equals(type)) {
            portalObjectMD = ContextMetaData.buildContextMetaData(contentProviderRegistry, portalObjectElt);
        }
        if (portalObjectMD != null) {
            Element resourceBundleElt;
            Element listenerElt;
            Element propertiesElt;
            Element securityConstraintElt = XMLTools.getUniqueChild((Element)portalObjectElt, (String)"security-constraint", (boolean)false);
            if (securityConstraintElt != null) {
                SecurityConstraintsMetaData securityConstraintsMD = SecurityConstraintsMetaData.buildSecurityConstraintMetaData((Element)securityConstraintElt);
                portalObjectMD.setSecurityConstraints(securityConstraintsMD);
            }
            if ((propertiesElt = XMLTools.getUniqueChild((Element)portalObjectElt, (String)"properties", (boolean)false)) != null) {
                PortalObjectMetaData.buildPropertiesMetaData(portalObjectMD, propertiesElt);
            }
            if ((listenerElt = XMLTools.getUniqueChild((Element)portalObjectElt, (String)"listener", (boolean)false)) != null) {
                PortalObjectMetaData.buildListenerMetaData(portalObjectMD, listenerElt);
            }
            if ((resourceBundleElt = XMLTools.getUniqueChild((Element)portalObjectElt, (String)"resource-bundle", (boolean)false)) != null) {
                PortalObjectMetaData.buildResourceBundleMetaData(portalObjectMD, resourceBundleElt);
                PortalObjectMetaData.buildSupportedLocalesMetaData(portalObjectMD, portalObjectElt);
            } else {
                PortalObjectMetaData.buildDisplayNameMetaData(portalObjectMD, portalObjectElt);
            }
        }
        return portalObjectMD;
    }

    public static void buildPropertiesMetaData(PortalObjectMetaData portalObjectMD, Element propertiesElt) {
        for (Element propertyElt : XMLTools.getChildren((Element)propertiesElt, (String)"property")) {
            Element nameElt = XMLTools.getUniqueChild((Element)propertyElt, (String)"name", (boolean)true);
            Element valueElt = XMLTools.getUniqueChild((Element)propertyElt, (String)"value", (boolean)true);
            String name = XMLTools.asString((Element)nameElt);
            String value = XMLTools.asString((Element)valueElt);
            portalObjectMD.getProperties().put(name, value);
        }
    }

    public static void buildDisplayNameMetaData(PortalObjectMetaData portalObjectMD, Element portalObjectElt) {
        Iterator displayNamesIt = XMLTools.getChildrenIterator((Element)portalObjectElt, (String)"display-name");
        HashMap<Locale, String> localizedStringValues = new HashMap<Locale, String>();
        while (displayNamesIt.hasNext()) {
            Element element = (Element)displayNamesIt.next();
            String lang = element.getAttribute("xml:lang");
            try {
                Locale locale = LocaleFormat.DEFAULT.getLocale(lang);
                localizedStringValues.put(locale, element.getTextContent());
            }
            catch (ConversionException e) {
                log.error((Object)("Cannot set localized display-name, for language: " + lang), (Throwable)e);
            }
        }
        if (localizedStringValues.size() != 0) {
            portalObjectMD.setDisplayName(new LocalizedString(localizedStringValues, Locale.ENGLISH));
        }
    }

    public static void buildSupportedLocalesMetaData(PortalObjectMetaData portalObjectMD, Element portalObjectElt) {
        Iterator supportedLocalesIt = XMLTools.getChildrenIterator((Element)portalObjectElt, (String)"supported-locale");
        ArrayList<Locale> supportedLocales = new ArrayList<Locale>();
        while (supportedLocalesIt.hasNext()) {
            Element element = (Element)supportedLocalesIt.next();
            supportedLocales.add(new Locale(element.getTextContent()));
        }
        portalObjectMD.setSupportedLocales(supportedLocales);
    }

    public static void buildListenerMetaData(PortalObjectMetaData portalObjectMD, Element listenerElt) {
        String listener = XMLTools.asString((Element)listenerElt);
        portalObjectMD.setListener(listener);
    }

    public static void buildResourceBundleMetaData(PortalObjectMetaData portalObjectMD, Element resourceBundleElt) {
        String resourceBundle = XMLTools.asString((Element)resourceBundleElt);
        portalObjectMD.setResourceBundle(resourceBundle);
    }

    public String toString() {
        String name = this.getClass().getName();
        return Tools.getShortNameOf(this.getClass()) + "[" + name + "]";
    }

    public String getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(String resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public List getSupportedLocales() {
        return this.supportedLocales;
    }

    public void setSupportedLocales(List supportedLocales) {
        this.supportedLocales = supportedLocales;
    }
}

