/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.portlet;

import java.util.Map;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.common.util.ParameterMap;
import org.jboss.portal.common.util.ParameterValidation;
import org.jboss.portal.portlet.OpaqueStateString;
import org.jboss.portal.portlet.ParametersStateString;
import org.jboss.portal.portlet.StateString;
import org.jboss.portal.portlet.cache.CacheLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletRequestDecoder {
    public static final int ACTION_PHASE = 1;
    public static final int RENDER_PHASE = 2;
    public static final int RESOURCE_PHASE = 3;
    public static final int PHASE_MASK = 3;
    public static final int MODE_MASK = 4;
    public static final int RESOURCE_ID_MASK = 4;
    public static final int WINDOW_STATE_MASK = 8;
    public static final int CACHEABILITY_MASK = 8;
    public static final int OPAQUE_MASK = 16;
    public static final String MODE_PARAMETER = "mode";
    public static final String WINDOW_STATE_PARAMETER = "windowstate";
    public static final String INTERACTION_STATE_PARAMETER = "is";
    public static final String NAVIGATIONAL_STATE_PARAMETER = "ns";
    public static final String RESOURCE_STATE_PARAMETER = "rs";
    public static final String CACHEABILITY_PARAMETER = "cacheability";
    public static final String RESOURCE_ID_PARAMETER = "id";
    public static final String META_PARAMETER = "action";
    public static final int ACTION_TYPE = 0;
    public static final int RENDER_TYPE = 1;
    public static final int NAV_TYPE = 2;
    public static final int RESOURCE_TYPE = 3;
    private Mode mode;
    private WindowState windowState;
    private StateString navigationalState;
    private StateString interactionState;
    private StateString resourceState;
    private ParameterMap form;
    private String resourceId;
    private CacheLevel cacheability;
    private int type;

    public void decode(Map<String, String[]> queryParams, Map<String, String[]> bodyParams) throws IllegalArgumentException {
        int phase;
        this.mode = null;
        this.windowState = null;
        this.navigationalState = null;
        this.interactionState = null;
        this.form = null;
        this.resourceId = null;
        this.cacheability = null;
        int meta = 0;
        String[] metaParam = queryParams.get(META_PARAMETER);
        if (metaParam != null) {
            try {
                meta = Integer.parseInt(metaParam[0], 16);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        if ((phase = meta & 3) != 0) {
            boolean opaque;
            switch (phase) {
                case 1: {
                    this.type = 0;
                    break;
                }
                case 2: {
                    this.type = 1;
                    break;
                }
                case 3: {
                    this.type = 3;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (this.type == 3) {
                if ((meta & 4) != 0) {
                    String[] resourceIdParam = queryParams.get(RESOURCE_ID_PARAMETER);
                    ParameterValidation.throwIllegalArgExceptionIfNull((Object)resourceIdParam, (String)"resource id");
                    this.resourceId = resourceIdParam[0];
                }
                if ((meta & 8) != 0) {
                    String[] cacheabilityParam = queryParams.get(CACHEABILITY_PARAMETER);
                    ParameterValidation.throwIllegalArgExceptionIfNull((Object)cacheabilityParam, (String)CACHEABILITY_PARAMETER);
                    this.cacheability = CacheLevel.valueOf((String)cacheabilityParam[0]);
                }
            } else {
                if ((meta & 4) != 0) {
                    String[] modeParam = queryParams.get(MODE_PARAMETER);
                    ParameterValidation.throwIllegalArgExceptionIfNull((Object)modeParam, (String)MODE_PARAMETER);
                    this.mode = Mode.create((String)modeParam[0]);
                }
                if ((meta & 8) != 0) {
                    String[] windowStateParam = queryParams.get(WINDOW_STATE_PARAMETER);
                    ParameterValidation.throwIllegalArgExceptionIfNull((Object)windowStateParam, (String)"window state");
                    this.windowState = WindowState.create((String)windowStateParam[0]);
                }
            }
            boolean bl = opaque = (meta & 0x10) != 0;
            if (!opaque) {
                ParametersStateString query = ParametersStateString.create();
                for (Map.Entry<String, String[]> entry : queryParams.entrySet()) {
                    int index = 0;
                    String name = entry.getKey();
                    String[] queryValues = entry.getValue();
                    if (META_PARAMETER.equals(name)) {
                        index = 1;
                    } else if (this.type == 3) {
                        if ((meta & 4) != 0 && RESOURCE_ID_PARAMETER.equals(name)) {
                            index = 1;
                        } else if ((meta & 8) != 0 && CACHEABILITY_PARAMETER.equals(name)) {
                            index = 1;
                        }
                    } else if ((meta & 4) != 0 && MODE_PARAMETER.equals(name)) {
                        index = 1;
                    } else if ((meta & 8) != 0 && WINDOW_STATE_PARAMETER.equals(name)) {
                        index = 1;
                    }
                    if (index >= queryValues.length) continue;
                    String[] values = new String[queryValues.length - index];
                    System.arraycopy(queryValues, index, values, 0, values.length);
                    query.setValues(name, values);
                }
                ParameterMap form = new ParameterMap();
                if (bodyParams != null) {
                    form.putAll(bodyParams);
                }
                switch (this.type) {
                    case 0: {
                        this.interactionState = query;
                        this.form = form;
                        break;
                    }
                    case 1: {
                        this.navigationalState = query;
                        break;
                    }
                    case 3: {
                        this.resourceState = query;
                        this.form = form;
                    }
                }
            } else {
                String[] ns = queryParams.get(NAVIGATIONAL_STATE_PARAMETER);
                if (ns != null) {
                    this.navigationalState = new OpaqueStateString(ns[0]);
                }
                if (this.type == 0) {
                    String[] is = queryParams.get(INTERACTION_STATE_PARAMETER);
                    if (is != null) {
                        this.interactionState = new OpaqueStateString(is[0]);
                    }
                    this.form = new ParameterMap();
                    if (bodyParams != null) {
                        this.form.putAll(bodyParams);
                    }
                }
            }
        } else {
            String[] windowStateParam;
            this.type = 2;
            String[] modeParam = queryParams.get(MODE_PARAMETER);
            if (modeParam != null) {
                this.mode = Mode.create((String)modeParam[0]);
            }
            if ((windowStateParam = queryParams.get(WINDOW_STATE_PARAMETER)) != null) {
                this.windowState = WindowState.create((String)windowStateParam[0]);
            }
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    public WindowState getWindowState() {
        return this.windowState;
    }

    public StateString getNavigationalState() {
        return this.navigationalState;
    }

    public StateString getInteractionState() {
        return this.interactionState;
    }

    public ParameterMap getForm() {
        return this.form;
    }

    public int getType() {
        return this.type;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public CacheLevel getCacheability() {
        return this.cacheability;
    }

    public StateString getResourceState() {
        return this.resourceState;
    }
}

