/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.servlet.jsp.taglib;

import java.util.LinkedList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.portlet.PortletConfig;
import javax.servlet.http.HttpServletRequest;
import org.jboss.portal.core.servlet.jsp.PortalJsp;
import org.jboss.portal.core.servlet.jsp.taglib.context.NamedContext;

public class PortalLib {
    public static String getMessage(String key) {
        ThreadLocal threadRequest = PortalJsp.request;
        HttpServletRequest request = (HttpServletRequest)threadRequest.get();
        Locale locale = request.getLocale();
        PortletConfig portletConfig = (PortletConfig)request.getAttribute("javax.portlet.config");
        ResourceBundle resourceBundle = portletConfig.getResourceBundle(locale);
        PortalJsp.logger.debug((Object)("Use locale:" + locale));
        try {
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            PortalJsp.logger.error((Object)("No such resource key in resource file: " + key));
            return key;
        }
    }

    public static String i18nOut(String key) {
        return PortalLib.getMessage(PortalLib.out(key));
    }

    public static String out(String key) {
        ThreadLocal contextStackLocal = PortalJsp.contextStack;
        LinkedList contextStack = (LinkedList)contextStackLocal.get();
        if (contextStack.isEmpty()) {
            PortalJsp.logger.warn((Object)("No context has been defined when trying to access " + key));
            return "";
        }
        String[] ctxNames = key.split("[.]");
        NamedContext tmp = null;
        int i = 0;
        for (i = 0; i < ctxNames.length - 1; ++i) {
            try {
                tmp = (NamedContext)contextStack.get(i + 1);
            }
            catch (IndexOutOfBoundsException e) {
                PortalJsp.logger.warn((Object)("The key you called: " + key + " is not valid, please check the key"));
                return "";
            }
            if (ctxNames[i].equals(tmp.getName())) continue;
            PortalJsp.logger.warn((Object)("The context you called: " + ctxNames[i] + " does not match " + tmp.getName()));
            return "";
        }
        if (contextStack.get(i) != null) {
            NamedContext ctx = (NamedContext)contextStack.get(i);
            return PortalLib.convert(ctx.getContext().get(ctxNames[ctxNames.length - 1]));
        }
        PortalJsp.logger.warn((Object)("There is no such context for " + key));
        return "";
    }

    private static String convert(String toto) {
        if (toto != null) {
            toto = toto.replaceAll("<", "&lt;");
            toto = toto.replaceAll(">", "&gt;");
        }
        return toto;
    }
}

