/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.admin.ui.actions;

import org.jboss.logging.Logger;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.PageContainer;
import org.jboss.portal.faces.gui.ManagedBean;

public class AddPageAction
extends ManagedBean {
    private static final Logger log = Logger.getLogger(AddPageAction.class);
    public PageContainer pageContainer;
    public String pageName;
    public Listener listener;
    public String messageTarget;
    protected static final String PAGE_TYPE = "PAGE_TYPE";

    public void execute() {
        this.pageName = this.checkNameValidity(this.pageName, this.messageTarget);
        if (this.pageName != null) {
            try {
                Page page = this.pageContainer.createPage(this.pageName);
                if (this.listener != null) {
                    this.listener.pageCreated(page);
                }
            }
            catch (Exception e) {
                log.error((Object)"An error occurred during page creation", (Throwable)e);
                this.beanContext.createErrorMessageFrom(this.messageTarget, e);
            }
        }
    }

    public PageContainer getPageContainer() {
        return this.pageContainer;
    }

    public void setPageContainer(PageContainer pageContainer) {
        this.pageContainer = pageContainer;
    }

    public String getMessageTarget() {
        return this.messageTarget;
    }

    public void setMessageTarget(String messageTarget) {
        this.messageTarget = messageTarget;
    }

    public Listener getListener() {
        return this.listener;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    protected String getObjectTypeName() {
        return PAGE_TYPE;
    }

    public boolean isAlreadyExisting(String objectName) {
        return this.pageContainer.getChild(objectName) != null;
    }

    public static interface Listener {
        public void pageCreated(Page var1);
    }
}

