/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.admin.ui.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.faces.context.FacesContext;
import org.jboss.portal.core.model.content.ContentType;
import org.jboss.portal.core.model.instance.InstanceContainer;
import org.jboss.portal.core.model.instance.InstanceDefinition;
import org.jboss.portal.core.model.portal.Context;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectContainer;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.portlet.Portlet;
import org.jboss.portal.portlet.PortletContext;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.federation.FederatedPortletInvoker;
import org.jboss.portal.portlet.federation.FederatingPortletInvoker;
import org.jboss.portal.security.AuthorizationDomainRegistry;
import org.jboss.portal.security.RoleSecurityBinding;
import org.jboss.portal.security.SecurityConstants;
import org.jboss.portal.security.spi.provider.DomainConfigurator;
import org.jboss.portal.theme.LayoutService;
import org.jboss.portal.theme.PortalLayout;

public class NewWindowWizard {
    private List steps = new ArrayList();
    private int currentStep;
    private FederatingPortletInvoker federatingPortletInvoker;
    private String selectedPortletId;
    private String selectedPortalId;
    private String selectedPageId;
    private String selectedRegionId;
    private String selectedPortletInvokerId;
    private String selectedParentPageId;
    private PortalObjectContainer portalObjectContainer;
    private InstanceContainer instanceContainer;
    private LayoutService layoutService;
    private AuthorizationDomainRegistry authorizationDomainRegistry;

    public NewWindowWizard() {
        this.steps.add("selectPortlet");
        this.steps.add("selectPortal");
        this.steps.add("selectPage");
        this.steps.add("selectRegion");
        this.steps.add("newWindowWizardConfirm");
        this.currentStep = 0;
    }

    public String next() {
        ++this.currentStep;
        return (String)this.steps.get(this.currentStep);
    }

    public String goTo() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        this.currentStep = Integer.parseInt((String)ctx.getExternalContext().getRequestParameterMap().get("step"));
        return (String)this.steps.get(this.currentStep);
    }

    public String previous() {
        --this.currentStep;
        return (String)this.steps.get(this.currentStep);
    }

    public String selectPortlet() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        this.selectedPortletId = (String)ctx.getExternalContext().getRequestParameterMap().get("id");
        this.selectedPortletInvokerId = (String)ctx.getExternalContext().getRequestParameterMap().get("portletInvokerId");
        this.currentStep = 1;
        return (String)this.steps.get(this.currentStep);
    }

    public String selectPortal() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        this.selectedPortalId = (String)ctx.getExternalContext().getRequestParameterMap().get("id");
        this.currentStep = 2;
        this.selectedPageId = null;
        this.selectedRegionId = null;
        this.selectedParentPageId = this.selectedPortalId;
        return (String)this.steps.get(this.currentStep);
    }

    public String selectPage() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        this.selectedPageId = (String)ctx.getExternalContext().getRequestParameterMap().get("id");
        this.currentStep = 3;
        this.selectedRegionId = null;
        return (String)this.steps.get(this.currentStep);
    }

    public String selectParentPage() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        this.selectedParentPageId = (String)ctx.getExternalContext().getRequestParameterMap().get("id");
        this.currentStep = 2;
        return (String)this.steps.get(this.currentStep);
    }

    public String up() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        String id = (String)ctx.getExternalContext().getRequestParameterMap().get("id");
        Page page = (Page)this.getObjectFromId(id);
        this.selectedParentPageId = page.getParent().getId().toString(PortalObjectPath.LEGACY_BASE64_FORMAT);
        this.currentStep = 2;
        return (String)this.steps.get(this.currentStep);
    }

    public String selectRegion() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        this.selectedRegionId = (String)ctx.getExternalContext().getRequestParameterMap().get("name");
        this.currentStep = 4;
        return (String)this.steps.get(this.currentStep);
    }

    public Portlet getSelectedPortlet() {
        FederatedPortletInvoker portletInvoker = this.federatingPortletInvoker.getFederatedInvoker(this.selectedPortletInvokerId);
        try {
            Portlet selectedPortlet = portletInvoker.getPortlet(PortletContext.createPortletContext((String)this.selectedPortletId));
            return selectedPortlet;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (PortletInvokerException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Page getSelectedPage() {
        return (Page)this.getObjectFromId(this.selectedPageId);
    }

    public PortalObject getSelectedParentPage() {
        return this.getObjectFromId(this.selectedParentPageId);
    }

    public Portal getSelectedPortal() {
        return (Portal)this.getObjectFromId(this.selectedPortalId);
    }

    public PortalObject getObjectFromId(String id) {
        PortalObjectId objectId = PortalObjectId.parse((String)id, (PortalObjectPath.Format)PortalObjectPath.LEGACY_BASE64_FORMAT);
        return this.getObjectFromId(objectId);
    }

    public PortalObject getObjectFromId(PortalObjectId id) {
        return this.portalObjectContainer.getObject(id);
    }

    public List getPortals() {
        Context root = this.portalObjectContainer.getContext();
        return new ArrayList(root.getChildren(2));
    }

    public List getPages() {
        if (this.selectedParentPageId != null) {
            Collection result = this.getSelectedParentPage().getChildren(4);
            if (result.size() != 0) {
                return new ArrayList(result);
            }
            return new ArrayList(this.getSelectedPage().getParent().getChildren(4));
        }
        return new ArrayList(this.getSelectedPortal().getChildren(4));
    }

    public String createWindow() {
        Portlet portlet = this.getSelectedPortlet();
        InstanceContainer container = this.instanceContainer;
        int id = container.getDefinitions().size();
        String instanceId = "wizardInstance_" + id;
        String windowId = "wizardWindow_" + id;
        try {
            if (container.getDefinition(instanceId) == null && this.getSelectedPage().getWindow(windowId) == null) {
                InstanceDefinition instance = container.createDefinition(instanceId, portlet.getContext().getId());
                DomainConfigurator configurator = this.authorizationDomainRegistry.getDomain("instance").getConfigurator();
                Set<RoleSecurityBinding> constraints = Collections.singleton(new RoleSecurityBinding("view", SecurityConstants.UNCHECKED_ROLE_NAME));
                configurator.setSecurityBindings(instance.getId(), constraints);
                Window window = this.getSelectedPage().createWindow(windowId, ContentType.PORTLET, instanceId);
                window.setDeclaredProperty("theme.region", this.getSelectedRegionId());
                window.setDeclaredProperty("theme.order", "2147483647");
                return this.reset();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String cancel() {
        return this.reset();
    }

    public String reset() {
        this.selectedPortletId = null;
        this.selectedPortalId = null;
        this.selectedPageId = null;
        this.selectedRegionId = null;
        this.selectedPortletInvokerId = null;
        this.selectedParentPageId = null;
        this.currentStep = 0;
        return "wizardMode";
    }

    public List getRegions() {
        Page page = this.getSelectedPage();
        String layoutId = page.getProperty("layout.id");
        PortalLayout layout = this.layoutService.getLayout(layoutId, false);
        return layout.getLayoutInfo().getRegionNames();
    }

    public String getSelectedPortletId() {
        return this.selectedPortletId;
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public String getSelectedPortalId() {
        return this.selectedPortalId;
    }

    public String getSelectedPageId() {
        return this.selectedPageId;
    }

    public String getSelectedParentPageId() {
        return this.selectedParentPageId;
    }

    public String getSelectedRegionId() {
        return this.selectedRegionId;
    }

    public FederatingPortletInvoker getFederatingPortletInvoker() {
        return this.federatingPortletInvoker;
    }

    public void setFederatingPortletInvoker(FederatingPortletInvoker federatingPortletInvoker) {
        this.federatingPortletInvoker = federatingPortletInvoker;
    }

    public PortalObjectContainer getPortalObjectContainer() {
        return this.portalObjectContainer;
    }

    public void setPortalObjectContainer(PortalObjectContainer portalObjectContainer) {
        this.portalObjectContainer = portalObjectContainer;
    }

    public LayoutService getLayoutService() {
        return this.layoutService;
    }

    public void setLayoutService(LayoutService layoutService) {
        this.layoutService = layoutService;
    }

    public InstanceContainer getInstanceContainer() {
        return this.instanceContainer;
    }

    public void setInstanceContainer(InstanceContainer instanceContainer) {
        this.instanceContainer = instanceContainer;
    }

    public AuthorizationDomainRegistry getAuthorizationDomainRegistry() {
        return this.authorizationDomainRegistry;
    }

    public void setAuthorizationDomainRegistry(AuthorizationDomainRegistry authorizationDomainRegistry) {
        this.authorizationDomainRegistry = authorizationDomainRegistry;
    }

    public boolean[] getEnabled() {
        boolean[] result = new boolean[this.steps.size()];
        result[0] = true;
        if (this.selectedPortletId != null) {
            result[1] = true;
        }
        if (this.selectedPortalId != null) {
            result[2] = true;
        }
        if (this.selectedPageId != null) {
            result[3] = true;
        }
        if (this.selectedRegionId != null) {
            result[4] = true;
        }
        return result;
    }
}

