/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.identity.ui.validators;

import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import javax.portlet.PortletContext;
import org.jboss.logging.Logger;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.Role;
import org.jboss.portal.identity.RoleModule;

public class RoleValidator
implements Validator {
    private RoleModule roleModule;
    private static final Logger log = Logger.getLogger(RoleValidator.class);

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        String rolename = (String)value;
        ResourceBundle bundle = ResourceBundle.getBundle("conf.bundles.Identity", context.getViewRoot().getLocale());
        PortletContext portletContext = (PortletContext)context.getExternalContext().getContext();
        this.roleModule = (RoleModule)portletContext.getAttribute("RoleModule");
        try {
            Role u = this.roleModule.findRoleByName(rolename);
            throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("IDENTITY_VALIDATION_ERROR_ROLENAME_TAKEN"), bundle.getString("IDENTITY_VALIDATION_ERROR_ROLENAME_TAKEN")));
        }
        catch (IllegalArgumentException e) {
            throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("IDENTITY_VALIDATION_ERROR_ROLENAME_ERROR"), bundle.getString("IDENTITY_VALIDATION_ERROR_ROLENAME_ERROR")));
        }
        catch (IdentityException e) {
            if (!e.getMessage().contains("No such role")) {
                log.error((Object)"Error validation rolename", (Throwable)e);
                throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("IDENTITY_VALIDATION_ERROR_ROLENAME_ERROR"), bundle.getString("IDENTITY_VALIDATION_ERROR_ROLENAME_ERROR")));
            }
            return;
        }
    }
}

