/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.portlet.PortletContext;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jboss.portletbridge.util.ServletBean;
import org.jboss.portletbridge.util.WebappHandler;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebXML {
    private static final String WEB_XML = "/WEB-INF/web.xml";
    List<String> facesServletMappings;
    Map<Class<? extends Throwable>, String> errorViews;
    Map<String, String> errorLocations;

    public void parse(InputStream webXml) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            WebappHandler handler = new WebappHandler(parser.getXMLReader());
            parser.parse(webXml, (DefaultHandler)handler);
            ServletBean facesServlet = handler.getFacesServlet();
            if (null == facesServlet) {
                throw new FacesException("Faces Servlet did not found, is this a JSF application?");
            }
            this.facesServletMappings = facesServlet.getMappings();
            this.errorLocations = handler.getErrorPages();
        }
        catch (Exception e) {
            throw new FacesException("XML parsing error", (Throwable)e);
        }
    }

    public List<String> getFacesServletMappings() {
        return this.facesServletMappings;
    }

    protected String getViewIdFromLocation(String location, String viewSuffix) {
        String viewId = null;
        for (String mapping : this.facesServletMappings) {
            String prefix;
            if (mapping.startsWith("*")) {
                String suffix = mapping.substring(1);
                if (!location.endsWith(suffix)) continue;
                viewId = location.substring(0, location.length() - suffix.length()) + viewSuffix;
                break;
            }
            if (!mapping.endsWith("*") || !location.startsWith(prefix = mapping.substring(0, mapping.length() - 1))) continue;
            int index = prefix.length();
            if (prefix.endsWith("/")) {
                --index;
            }
            viewId = location.substring(index);
        }
        return viewId;
    }

    public void parse(PortletContext portletContext) {
        InputStream inputStream = portletContext.getResourceAsStream(WEB_XML);
        this.parse(inputStream);
        String viewSuffix = portletContext.getInitParameter("javax.faces.DEFAULT_SUFFIX");
        if (null == viewSuffix) {
            viewSuffix = ".jsp";
        }
        this.errorViews = this.createErrorViews(viewSuffix);
        try {
            inputStream.close();
        }
        catch (IOException e) {
            portletContext.log("Error parsing web.xml", (Throwable)e);
        }
    }

    protected Map<Class<? extends Throwable>, String> createErrorViews(String viewSuffix) {
        LinkedHashMap<Class<? extends Throwable>, String> viewsMap = new LinkedHashMap<Class<? extends Throwable>, String>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (null == classLoader) {
            classLoader = this.getClass().getClassLoader();
        }
        for (Map.Entry<String, String> entry : this.errorLocations.entrySet()) {
            try {
                Class<Throwable> clazz = classLoader.loadClass(entry.getKey()).asSubclass(Throwable.class);
                String viewId = this.getViewIdFromLocation(entry.getValue(), viewSuffix);
                if (null == viewId) continue;
                viewsMap.put(clazz, viewId);
            }
            catch (ClassNotFoundException e) {}
        }
        return viewsMap;
    }

    public Map<Class<? extends Throwable>, String> getErrorViews() {
        return this.errorViews;
    }
}

