/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.ant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.RemoteContainer;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.jboss.JBossJMXDeployer;
import org.codehaus.cargo.generic.DefaultContainerFactory;
import org.codehaus.cargo.generic.configuration.DefaultConfigurationFactory;

public abstract class AbstractDeploymentTask
extends Task {
    private File file = null;
    private String config = "default";

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public void execute() throws BuildException {
        DefaultConfigurationFactory cfgFactory = new DefaultConfigurationFactory();
        Configuration cfg = cfgFactory.createConfiguration("jboss4x", ConfigurationType.RUNTIME);
        if (!"default".equals(this.config)) {
            throw new BuildException("Unknown configuration " + this.config);
        }
        cfg.setProperty("cargo.protocol", "http");
        cfg.setProperty("cargo.hostname", "localhost");
        cfg.setProperty("cargo.servlet.port", "8080");
        if (this.file == null) {
            throw new BuildException("No specified file to deploy");
        }
        DefaultContainerFactory containerFactory = new DefaultContainerFactory();
        RemoteContainer container = (RemoteContainer)containerFactory.createContainer("jboss4x", ContainerType.REMOTE, cfg);
        JBossJMXDeployer deployer = new JBossJMXDeployer(container);
        this.execute(deployer);
    }

    protected abstract void execute(JBossJMXDeployer var1);
}

