/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.util;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapBuilder<M extends Map<K, V>, K, V> {
    private final M map;

    private MapBuilder(M map) {
        if (map == null) {
            throw new IllegalArgumentException();
        }
        this.map = map;
    }

    public static <K, V> MapBuilder<HashMap<K, V>, K, V> hashMap() {
        return new MapBuilder(new HashMap());
    }

    public static <K, V> MapBuilder<HashMap<K, V>, K, V> hashMap(K k, V v) {
        MapBuilder<HashMap<K, V>, K, V> builder = new MapBuilder<HashMap<K, V>, K, V>(new HashMap());
        builder.put(k, v);
        return builder;
    }

    public static <K, V> MapBuilder<TreeMap<K, V>, K, V> treeMap() {
        return new MapBuilder(new TreeMap());
    }

    public static <K, V> MapBuilder<TreeMap<K, V>, K, V> treeMap(K k, V v) {
        MapBuilder<TreeMap<K, V>, K, V> builder = new MapBuilder<TreeMap<K, V>, K, V>(new TreeMap());
        builder.put(k, v);
        return builder;
    }

    public static <K, V> MapBuilder<LinkedHashMap<K, V>, K, V> linkedHashMap() {
        return new MapBuilder(new LinkedHashMap());
    }

    public static <K, V> MapBuilder<LinkedHashMap<K, V>, K, V> linkedHashMap(K k, V v) {
        MapBuilder<LinkedHashMap<K, V>, K, V> builder = new MapBuilder<LinkedHashMap<K, V>, K, V>(new LinkedHashMap());
        builder.put(k, v);
        return builder;
    }

    public static <M extends Map<K, V>, K, V> MapBuilder<M, K, V> create(M m) {
        return new MapBuilder<M, K, V>(m);
    }

    public MapBuilder<M, K, V> put(K key, V value) {
        this.map.put(key, value);
        return this;
    }

    public MapBuilder<M, K, V> putAll(M all) {
        this.map.putAll(all);
        return this;
    }

    public M get() {
        return this.map;
    }
}

