/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import org.jboss.deployment.DeploymentException;
import org.jboss.metadata.MetaData;
import org.w3c.dom.Element;

public class J2eeModuleMetaData
extends MetaData {
    public static final int EJB = 0;
    public static final int WEB = 1;
    public static final int CLIENT = 2;
    public static final int CONNECTOR = 3;
    public static final int SERVICE = 4;
    public static final int HAR = 5;
    private static final String[] tags = new String[]{"ejb", "web", "java", "connector", "service", "har"};
    int type;
    String fileName;
    String alternativeDD;
    String webContext;

    public boolean isEjb() {
        return this.type == 0;
    }

    public boolean isWeb() {
        return this.type == 1;
    }

    public boolean isJava() {
        return this.type == 2;
    }

    public boolean isConnector() {
        return this.type == 3;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getAlternativeDD() {
        return this.alternativeDD;
    }

    public String getWebContext() {
        if (this.type == 1) {
            return this.webContext;
        }
        return null;
    }

    public void importXml(Element rootElement) throws DeploymentException {
        String rootTag = rootElement.getOwnerDocument().getDocumentElement().getTagName();
        if (rootTag.equals("application")) {
            this.importXml(rootElement, false);
        } else if (rootTag.equals("jboss-app")) {
            this.importXml(rootElement, true);
        } else {
            throw new DeploymentException("Unrecognized root tag: " + rootTag);
        }
    }

    protected void importXml(Element element, boolean jbossSpecific) throws DeploymentException {
        String name = element.getTagName();
        if (name.equals("module")) {
            boolean done = false;
            for (int i = 0; !done && i < tags.length; ++i) {
                Element child = J2eeModuleMetaData.getOptionalChild(element, tags[i]);
                if (child == null) continue;
                this.type = i;
                switch (this.type) {
                    case 4: {
                        if (!jbossSpecific) {
                            throw new DeploymentException("Service archives must be in jboss-app.xml");
                        }
                    }
                    case 5: {
                        if (!jbossSpecific) {
                            throw new DeploymentException("Hibernate archives must be in jboss-app.xml");
                        }
                    }
                    case 0: 
                    case 2: 
                    case 3: {
                        this.fileName = J2eeModuleMetaData.getElementContent(child);
                        this.alternativeDD = J2eeModuleMetaData.getElementContent(J2eeModuleMetaData.getOptionalChild(element, "alt-dd"));
                        break;
                    }
                    case 1: {
                        this.fileName = J2eeModuleMetaData.getElementContent(J2eeModuleMetaData.getUniqueChild(child, "web-uri"));
                        this.webContext = J2eeModuleMetaData.getElementContent(J2eeModuleMetaData.getOptionalChild(child, "context-root"));
                        this.alternativeDD = J2eeModuleMetaData.getElementContent(J2eeModuleMetaData.getOptionalChild(element, "alt-dd"));
                    }
                }
                done = true;
            }
            if (!done) {
                StringBuffer msg = new StringBuffer("Invalid module content, must be one of: ");
                for (int i = 0; i < tags.length; ++i) {
                    msg.append(tags[i]);
                    msg.append(", ");
                }
                throw new DeploymentException(msg.toString());
            }
        } else {
            throw new DeploymentException("non-module tag in application dd: " + name);
        }
    }
}

